/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.logging;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.plugin.base.logging.SessionInterpolatedValues;
import jakarta.validation.constraints.AssertTrue;

public class FormatBasedRemoteQueryModifierConfig {
    private String format = "";

    @Config(value="query.comment-format")
    @ConfigDescription(value="Format in which logs about query execution context should be added as comments sent through jdbc driver.")
    public FormatBasedRemoteQueryModifierConfig setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    @AssertTrue(message="Incorrect format it may consist of only letters, digits, underscores, commas, spaces, equal signs and predefined values")
    @AssertTrue(message="Incorrect format it may consist of only letters, digits, underscores, commas, spaces, equal signs and predefined values") boolean isFormatValid() {
        return FormatInterpolator.hasValidPlaceholders((String)this.format, (FormatInterpolator.InterpolatedValue[])SessionInterpolatedValues.values());
    }
}

