/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import io.trino.spi.connector.DynamicFilter;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DynamicFilteringStats {
    private final CounterStat totalDynamicFilters = new CounterStat();
    private final CounterStat completedDynamicFilters = new CounterStat();
    private final CounterStat awaitableDynamicFilters = new CounterStat();
    private final TimeStat dynamicFilterWaitingTime = new TimeStat(TimeUnit.MILLISECONDS);

    @Managed
    @Nested
    public CounterStat getTotalDynamicFilters() {
        return this.totalDynamicFilters;
    }

    @Managed
    @Nested
    public CounterStat getCompletedDynamicFilters() {
        return this.completedDynamicFilters;
    }

    @Managed
    @Nested
    public CounterStat getAwaitableDynamicFilters() {
        return this.awaitableDynamicFilters;
    }

    @Managed
    @Nested
    public TimeStat getDynamicFilterWaitingTime() {
        return this.dynamicFilterWaitingTime;
    }

    public void processDynamicFilter(DynamicFilter dynamicFilter, Duration waitingTime) {
        this.totalDynamicFilters.update(1L);
        if (dynamicFilter.isComplete()) {
            this.completedDynamicFilters.update(1L);
        }
        if (dynamicFilter.isAwaitable()) {
            this.awaitableDynamicFilters.update(1L);
        }
        this.dynamicFilterWaitingTime.add(waitingTime);
    }
}

