/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.reflect.Reflection;
import io.trino.plugin.base.util.LoggingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.testng.annotations.Test;

public class TestLoggingInvocationHandler {
    private static final String DURATION_PATTERN = "\\d+(\\.\\d+)?\\w{1,2}";

    @Test
    public void testLoggingAndExceptions() {
        SomeInterface delegate = new SomeInterface(){

            @Override
            public String run(boolean ok, String s) {
                if (!ok) {
                    throw new ArrayStoreException(s);
                }
                return null;
            }
        };
        ArrayList messages = new ArrayList();
        LoggingInvocationHandler handler = new LoggingInvocationHandler((Object)delegate, messages::add);
        SomeInterface proxy = (SomeInterface)Reflection.newProxy(SomeInterface.class, (InvocationHandler)handler);
        proxy.run(true, "xyz");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> proxy.run(false, "bad")).isInstanceOf(ArrayStoreException.class)).hasMessage("bad");
        ((ListAssert)Assertions.assertThat(messages).hasSize(2)).satisfies(new ThrowingConsumer[]{list -> {
            Assertions.assertThat((String)((String)list.get(0))).matches((CharSequence)"\\QInvocation of run(ok=true, s='xyz') succeeded in\\E \\d+(\\.\\d+)?\\w{1,2}");
            Assertions.assertThat((String)((String)list.get(1))).matches((CharSequence)"\\QInvocation of run(ok=false, s='bad') took\\E \\d+(\\.\\d+)?\\w{1,2} \\Qand failed with java.lang.ArrayStoreException: bad\\E");
        }});
    }

    @Test
    public void testLoggingResult() {
        SomeInterface delegate = new SomeInterface(){

            @Override
            public String run(boolean ok, String s) {
                if (!ok) {
                    throw new ArrayStoreException(s);
                }
                return "result=" + s;
            }
        };
        ArrayList messages = new ArrayList();
        LoggingInvocationHandler handler = new LoggingInvocationHandler((Object)delegate, messages::add, true);
        SomeInterface proxy = (SomeInterface)Reflection.newProxy(SomeInterface.class, (InvocationHandler)handler);
        proxy.run(true, "xyz");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> proxy.run(false, "bad")).isInstanceOf(ArrayStoreException.class)).hasMessage("bad");
        ((ListAssert)Assertions.assertThat(messages).hasSize(2)).satisfies(new ThrowingConsumer[]{list -> {
            Assertions.assertThat((String)((String)list.get(0))).matches((CharSequence)"\\QInvocation of run(ok=true, s='xyz') succeeded in\\E \\d+(\\.\\d+)?\\w{1,2} and returned 'result=xyz'");
            Assertions.assertThat((String)((String)list.get(1))).matches((CharSequence)"\\QInvocation of run(ok=false, s='bad') took\\E \\d+(\\.\\d+)?\\w{1,2} \\Qand failed with java.lang.ArrayStoreException: bad\\E");
        }});
    }

    private static interface SomeInterface {
        default public String run(boolean ok, String s) {
            return null;
        }
    }
}

