/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import io.trino.plugin.base.util.JsonUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJsonUtils {
    @Test
    public void testLowercaseEnum() throws IOException {
        TestObject parsed = (TestObject)JsonUtils.parseJson((byte[])"{\"testEnum\": \"option_a\"}".getBytes(StandardCharsets.US_ASCII), TestObject.class);
        Assertions.assertThat((Comparable)((Object)parsed.testEnum)).isEqualTo((Object)TestEnum.OPTION_A);
    }

    @Test
    public void testTrailingContent() throws IOException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtils.parseJson((String)"{} {}}", JsonNode.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtils.parseJson((String)"{} not even a JSON here", JsonNode.class)).isInstanceOf(UncheckedIOException.class)).hasMessage("Could not parse JSON").hasStackTraceContaining("Unrecognized token 'not': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtils.parseJson((byte[])"{} {}}".getBytes(StandardCharsets.US_ASCII), TestObject.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtils.parseJson((byte[])"{} not even a JSON here".getBytes(StandardCharsets.US_ASCII), TestObject.class)).isInstanceOf(UncheckedIOException.class)).hasMessage("Could not parse JSON").hasStackTraceContaining("Unrecognized token 'not': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
    }

    @Test
    public void testFactoryHasNoReadContraints() {
        TestJsonUtils.assertReadConstraints(JsonUtils.jsonFactory().streamReadConstraints());
        TestJsonUtils.assertReadConstraints(JsonUtils.jsonFactoryBuilder().build().streamReadConstraints());
    }

    @Test
    public void testBuilderHasNoReadConstraints() {
        TestJsonUtils.assertReadConstraints(JsonUtils.jsonFactoryBuilder().build().streamReadConstraints());
    }

    private static void assertReadConstraints(StreamReadConstraints constraints) {
        Assertions.assertThat((int)constraints.getMaxStringLength()).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((int)constraints.getMaxNestingDepth()).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((int)constraints.getMaxNumberLength()).isEqualTo(Integer.MAX_VALUE);
    }

    public static class TestObject {
        @JsonProperty
        public TestEnum testEnum;
    }

    static enum TestEnum {
        OPTION_A,
        OPTION_B;

    }
}

