/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.plugin.base.security.FileBasedSystemAccessControl;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.util.Files;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseFileBasedSystemAccessControlTest {
    private static final Identity alice = Identity.forUser((String)"alice").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity kerberosValidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("alice/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidNonAsciiUser = Identity.forUser((String)"\u0194\u0194\u0194").withPrincipal((Principal)new KerberosPrincipal("\u0194\u0194\u0194/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInvalidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("mallory/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("valid/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("invalid/example.com@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexWildDot = Identity.forUser((String)".*").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexEndQuote = Identity.forUser((String)"\\E").withPrincipal((Principal)new KerberosPrincipal("special/\\E@EXAMPLE.COM")).build();
    private static final Identity invalidSpecialRegex = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity bob = Identity.forUser((String)"bob").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity admin = Identity.forUser((String)"alberto").withEnabledRoles((Set)ImmutableSet.of((Object)"admin")).withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity nonAsciiUser = Identity.ofUser((String)"\u0194\u0194\u0194");
    private static final CatalogSchemaTableName aliceView = new CatalogSchemaTableName("alice-catalog", "schema", "view");
    private static final Optional<QueryId> queryId = Optional.empty();
    private static final Identity charlie = Identity.forUser((String)"charlie").withGroups((Set)ImmutableSet.of((Object)"guests")).build();
    private static final Identity dave = Identity.forUser((String)"dave").withGroups((Set)ImmutableSet.of((Object)"contractors")).build();
    private static final Identity joe = Identity.ofUser((String)"joe");
    private static final Identity any = Identity.ofUser((String)"any");
    private static final Identity anyone = Identity.ofUser((String)"anyone");
    private static final SystemSecurityContext ADMIN = new SystemSecurityContext(admin, queryId);
    private static final SystemSecurityContext BOB = new SystemSecurityContext(bob, queryId);
    private static final SystemSecurityContext CHARLIE = new SystemSecurityContext(charlie, queryId);
    private static final SystemSecurityContext ALICE = new SystemSecurityContext(alice, queryId);
    private static final SystemSecurityContext JOE = new SystemSecurityContext(joe, queryId);
    private static final SystemSecurityContext UNKNOWN = new SystemSecurityContext(Identity.ofUser((String)"some-unknown-user-id"), queryId);
    private static final String SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE = "Cannot show schemas";
    private static final String CREATE_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot create schema .*";
    private static final String DROP_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot drop schema .*";
    private static final String RENAME_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot rename schema from .* to .*";
    private static final String SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot show create schema for .*";
    private static final String GRANT_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot grant privilege %s on schema %s%s";
    private static final String DENY_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot deny privilege %s on schema %s%s";
    private static final String REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot revoke privilege %s on schema %s%s";
    private static final String SHOWN_TABLES_ACCESS_DENIED_MESSAGE = "Cannot show tables of .*";
    private static final String SELECT_TABLE_ACCESS_DENIED_MESSAGE = "Cannot select from table .*";
    private static final String SHOW_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot show columns of table .*";
    private static final String ADD_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot add a column to table .*";
    private static final String DROP_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot drop a column from table .*";
    private static final String RENAME_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot rename a column in table .*";
    private static final String TABLE_COMMENT_ACCESS_DENIED_MESSAGE = "Cannot comment table to .*";
    private static final String INSERT_TABLE_ACCESS_DENIED_MESSAGE = "Cannot insert into table .*";
    private static final String DELETE_TABLE_ACCESS_DENIED_MESSAGE = "Cannot delete from table .*";
    private static final String TRUNCATE_TABLE_ACCESS_DENIED_MESSAGE = "Cannot truncate table .*";
    private static final String DROP_TABLE_ACCESS_DENIED_MESSAGE = "Cannot drop table .*";
    private static final String CREATE_TABLE_ACCESS_DENIED_MESSAGE = "Cannot show create table for .*";
    private static final String RENAME_TABLE_ACCESS_DENIED_MESSAGE = "Cannot rename table .*";
    private static final String SET_TABLE_PROPERTIES_ACCESS_DENIED_MESSAGE = "Cannot set table properties to .*";
    private static final String CREATE_VIEW_ACCESS_DENIED_MESSAGE = "View owner '.*' cannot create view that selects from .*";
    private static final String CREATE_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE = "Cannot create materialized view .*";
    private static final String DROP_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE = "Cannot drop materialized view .*";
    private static final String REFRESH_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE = "Cannot refresh materialized view .*";
    private static final String SET_MATERIALIZED_VIEW_PROPERTIES_ACCESS_DENIED_MESSAGE = "Cannot set properties of materialized view .*";
    private static final String GRANT_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE = "Cannot grant privilege DELETE on table .*";
    private static final String DENY_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE = "Cannot deny privilege DELETE on table .*";
    private static final String REVOKE_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE = "Cannot revoke privilege DELETE on table .*";
    private static final String SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE = "Cannot set system session property .*";
    private static final String SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE = "Cannot set catalog session property .*";
    private static final String EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE = "Cannot execute function .*";
    private static final String GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE = ".* cannot grant .*";

    protected abstract SystemAccessControl newFileBasedSystemAccessControl(File var1, Map<String, String> var2);

    @Test
    public void testEverythingImplemented() throws NoSuchMethodException {
        InterfaceTestUtils.assertAllMethodsOverridden(SystemAccessControl.class, FileBasedSystemAccessControl.class, (Set)ImmutableSet.of((Object)FileBasedSystemAccessControl.class.getMethod("checkCanViewQueryOwnedBy", SystemSecurityContext.class, Identity.class), (Object)FileBasedSystemAccessControl.class.getMethod("filterViewQueryOwnedBy", SystemSecurityContext.class, Collection.class), (Object)FileBasedSystemAccessControl.class.getMethod("checkCanKillQueryOwnedBy", SystemSecurityContext.class, Identity.class)));
    }

    @Test
    public void testRefreshing() throws Exception {
        File configFile = Files.newTemporaryFile();
        configFile.deleteOnExit();
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("file-based-system-catalog.json")), (File)configFile);
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.refresh-period", (Object)"1ms"));
        SystemSecurityContext alice = new SystemSecurityContext(BaseFileBasedSystemAccessControlTest.alice, queryId);
        accessControl.checkCanCreateView(alice, aliceView);
        accessControl.checkCanCreateView(alice, aliceView);
        accessControl.checkCanCreateView(alice, aliceView);
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("file-based-system-security-config-file-with-unknown-rules.json")), (File)configFile);
        Thread.sleep(2L);
        Assertions.assertThatThrownBy(() -> accessControl.checkCanCreateView(alice, aliceView)).hasMessageContaining("Failed to convert JSON tree node");
        Assertions.assertThatThrownBy(() -> accessControl.checkCanCreateView(alice, aliceView)).hasMessageContaining("Failed to convert JSON tree node");
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("file-based-system-catalog.json")), (File)configFile);
        Thread.sleep(2L);
        accessControl.checkCanCreateView(alice, aliceView);
    }

    @Test
    public void testEmptyFile() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("empty.json");
        accessControl.checkCanCreateSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"), (Map)ImmutableMap.of());
        accessControl.checkCanDropSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"));
        accessControl.checkCanRenameSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"), "new_unknown");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for schema some-catalog.unknown to ROLE some_role");
        accessControl.checkCanShowCreateSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"));
        accessControl.checkCanSelectFromColumns(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), (Set)ImmutableSet.of());
        accessControl.checkCanShowColumns(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanInsertIntoTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanDeleteFromTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanTruncateTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanCreateTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), Map.of());
        accessControl.checkCanDropTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanTruncateTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanRenameTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), new CatalogSchemaTableName("some-catalog", "unknown", "new_unknown"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for table some-catalog.unknown.unknown to ROLE some_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for view some-catalog.unknown.unknown to ROLE some_role");
        accessControl.checkCanCreateMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), Map.of());
        accessControl.checkCanDropMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanRefreshMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for view some-catalog.unknown.unknown to ROLE some_role");
        accessControl.checkCanSetUser(Optional.empty(), "unknown");
        accessControl.checkCanSetUser(Optional.of(new KerberosPrincipal("stuff@example.com")), "unknown");
        accessControl.checkCanSetSystemSessionProperty(UNKNOWN, "anything");
        accessControl.checkCanSetCatalogSessionProperty(UNKNOWN, "unknown", "anything");
        accessControl.checkCanExecuteQuery(UNKNOWN);
        accessControl.checkCanViewQueryOwnedBy(UNKNOWN, anyone);
        accessControl.checkCanKillQueryOwnedBy(UNKNOWN, anyone);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanReadSystemInformation(UNKNOWN), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanWriteSystemInformation(UNKNOWN), "Cannot write system information");
    }

    @Test
    public void testEmptyFunctionKind() {
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("empty-functions-kind.json")).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("functionKinds cannot be empty, provide at least one function kind [SCALAR, AGGREGATE, WINDOW, TABLE]");
    }

    @Test
    public void testDisallowFunctionKindRuleCombination() {
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("file-based-disallow-function-rule-combination.json")).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("Cannot define catalog for others function kinds than TABLE");
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("file-based-disallow-function-rule-combination-without-table.json")).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("Cannot define catalog for others function kinds than TABLE");
    }

    @Test
    public void testSchemaRulesForCheckCanCreateSchema() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        ImmutableMap properties = ImmutableMap.of();
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"), (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"), (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"), (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"), (Map)properties);
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "bob"), (Map)properties);
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "staff"), (Map)properties);
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"), (Map)properties);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$11(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"), (Map)properties);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$12(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$13(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$14(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanDropSchema() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"));
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"));
        accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "test")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanRenameSchema() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"), "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"), "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"), "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"), "new_schema");
        accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "bob"), "staff");
        accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "staff"), "authenticated");
        accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"), "bob");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "test"), "bob"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "bob"), "test"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob"), "new_schema"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff"), "new_schema"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"), "authenticated");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test"), "new_schema"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanShowCreateSchema() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"));
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"));
        accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "test")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test(dataProvider="privilegeGrantOption")
    public void testGrantSchemaPrivilege(Privilege privilege, boolean grantOption) {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.bob", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.staff", ""));
        accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
    }

    @Test
    public void testDenySchemaPrivilege() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "bob"), grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "staff"), grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "authenticated"), grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "test"), grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "bob"), grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "staff"), grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "authenticated"), grantee);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "test"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.test", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "bob"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.bob", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "staff"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.staff", ""));
        accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "authenticated"), grantee);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "test"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.test", ""));
    }

    @Test(dataProvider="privilegeGrantOption")
    public void testRevokeSchemaPrivilege(Privilege privilege, boolean grantOption) {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.bob", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.staff", ""));
        accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
    }

    @DataProvider(name="privilegeGrantOption")
    public Object[][] privilegeGrantOption() {
        return (Object[][])EnumSet.allOf(Privilege.class).stream().flatMap(privilege -> Stream.of(true, false).map(grantOption -> new Object[]{privilege, grantOption})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test
    public void testTableRulesForCheckCanSelectFromColumns() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "test", "test"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private", (Object)"restricted"));
        accessControl.checkCanSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"bobcolumn"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private")), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSelectFromColumns(JOE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSelectFromColumns(ADMIN, new CatalogSchemaTableName("secret", "secret", "secret"), (Set)ImmutableSet.of()), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSelectFromColumns(JOE, new CatalogSchemaTableName("secret", "secret", "secret"), (Set)ImmutableSet.of()), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanCreateViewWithSelectFromColumns() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of()), CREATE_VIEW_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanCreateViewWithSelectFromColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private"));
        accessControl.checkCanCreateViewWithSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of((Object)"bobcolumn"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private")), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanShowColumns() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanShowColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        accessControl.checkCanShowColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
    }

    @Test
    public void testTableRulesForCheckCanShowColumnsWithNoAccess() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), SHOW_COLUMNS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("some-catalog", "bobschema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFunctionRulesForCheckExecuteAndGrantExecuteFunctionWithNoAccess() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ALICE, "some_function"), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.AGGREGATE, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.SCALAR, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_table_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.WINDOW, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "some_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, "some_function", grantee, true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.AGGREGATE, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function"), grantee, true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.SCALAR, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function"), grantee, true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_table_function"), grantee, true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.WINDOW, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function"), grantee, true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForFilterColumns() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        Assert.assertEquals((Set)accessControl.filterColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b")), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"));
        Assert.assertEquals((Set)accessControl.filterColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b")), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"));
        Assert.assertEquals((Set)accessControl.filterColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b")), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
    }

    @Test
    public void testTableFilter() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table-filter.json");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assert.assertEquals((Set)accessControl.filterTables(ALICE, "any", (Set)tables), (Set)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).build());
        Assert.assertEquals((Set)accessControl.filterTables(BOB, "any", (Set)tables), (Set)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).build());
        Assert.assertEquals((Set)accessControl.filterTables(ADMIN, "any", (Set)tables), (Set)ImmutableSet.builder().add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build());
    }

    @Test
    public void testTableFilterNoAccess() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assert.assertEquals((Set)accessControl.filterTables(ALICE, "any", (Set)tables), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterTables(BOB, "any", (Set)tables), (Set)ImmutableSet.of());
    }

    @Test
    public void testTableRulesForFilterColumnsWithNoAccess() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        Assert.assertEquals((Set)accessControl.filterColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), (Set)ImmutableSet.of((Object)"a")), (Set)ImmutableSet.of());
    }

    @Test
    public void testTableRulesForCheckCanInsertIntoTable() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        BaseFileBasedSystemAccessControlTest.assertTableRulesForCheckCanInsertIntoTable(accessControl);
    }

    private static void assertTableRulesForCheckCanInsertIntoTable(SystemAccessControl accessControl) {
        accessControl.checkCanInsertIntoTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        accessControl.checkCanInsertIntoTable(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanInsertIntoTable(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), INSERT_TABLE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanInsertIntoTable(BOB, new CatalogSchemaTableName("some-catalog", "test", "test")), INSERT_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDropTable() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDropTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), DROP_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDropMaterializedView() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDropMaterializedView(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropMaterializedView(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view")), DROP_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanCreateMaterializedView() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanCreateMaterializedView(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), Map.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanCreateMaterializedView(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), Map.of()), CREATE_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRefreshMaterializedView() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRefreshMaterializedView(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRefreshMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view")), REFRESH_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanSetMaterializedViewProperties() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSetMaterializedViewProperties(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), (Map)ImmutableMap.of());
        accessControl.checkCanSetMaterializedViewProperties(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alice-materialized-view"), (Map)ImmutableMap.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetMaterializedViewProperties(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), (Map)ImmutableMap.of()), SET_MATERIALIZED_VIEW_PROPERTIES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetMaterializedViewProperties(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), (Map)ImmutableMap.of()), SET_MATERIALIZED_VIEW_PROPERTIES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDeleteFromTable() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDeleteFromTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDeleteFromTable(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), DELETE_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanTruncateTable() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanTruncateTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanTruncateTable(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), TRUNCATE_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanGrantTablePrivilege() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanGrantTablePrivilege(ADMIN, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantTablePrivilege(BOB, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false), GRANT_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDenyTablePrivilege() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDenyTablePrivilege(ADMIN, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenyTablePrivilege(BOB, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null), DENY_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRevokeTablePrivilege() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRevokeTablePrivilege(ADMIN, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeTablePrivilege(BOB, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false), REVOKE_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanShowCreateTable() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanShowCreateTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), CREATE_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanAddColumn() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanAddColumn(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanAddColumn(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), ADD_COLUMNS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDropColumn() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDropColumn(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropColumn(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), DROP_COLUMNS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRenameColumn() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRenameColumn(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameColumn(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), RENAME_COLUMNS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForMixedGroupUsers() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table-mixed-groups.json");
        SystemSecurityContext userGroup1Group2 = new SystemSecurityContext(Identity.forUser((String)"user_1_2").withGroups((Set)ImmutableSet.of((Object)"group1", (Object)"group2")).build(), Optional.empty());
        SystemSecurityContext userGroup2 = new SystemSecurityContext(Identity.forUser((String)"user_2").withGroups((Set)ImmutableSet.of((Object)"group2")).build(), Optional.empty());
        Assert.assertEquals((Object)accessControl.getColumnMask(userGroup1Group2, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"), "col_a", (Type)VarcharType.VARCHAR), Optional.empty());
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(userGroup2, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"), "col_a", (Type)VarcharType.VARCHAR).orElseThrow(), new ViewExpression(Optional.empty(), Optional.of("some-catalog"), Optional.of("my_schema"), "'mask_a'"));
        SystemSecurityContext userGroup1Group3 = new SystemSecurityContext(Identity.forUser((String)"user_1_3").withGroups((Set)ImmutableSet.of((Object)"group1", (Object)"group3")).build(), Optional.empty());
        SystemSecurityContext userGroup3 = new SystemSecurityContext(Identity.forUser((String)"user_3").withGroups((Set)ImmutableSet.of((Object)"group3")).build(), Optional.empty());
        Assert.assertEquals((Collection)accessControl.getRowFilters(userGroup1Group3, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table")), (Collection)ImmutableList.of());
        List rowFilters = accessControl.getRowFilters(userGroup3, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"));
        Assert.assertEquals((int)rowFilters.size(), (int)1);
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), new ViewExpression(Optional.empty(), Optional.of("some-catalog"), Optional.of("my_schema"), "country='US'"));
    }

    @Test
    public void testTableRulesForCheckCanSetTableComment() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSetTableComment(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableComment(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), TABLE_COMMENT_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRenameTable() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRenameTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), new CatalogSchemaTableName("some-catalog", "aliceschema", "newbobtable"));
        accessControl.checkCanRenameTable(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alicetable"), new CatalogSchemaTableName("some-catalog", "aliceschema", "newalicetable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), new CatalogSchemaTableName("some-catalog", "bobschema", "newbobtable")), RENAME_TABLE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameTable(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alicetable"), new CatalogSchemaTableName("some-catalog", "bobschema", "newalicetable")), RENAME_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanSetTableProperties() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSetTableProperties(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), (Map)ImmutableMap.of());
        accessControl.checkCanSetTableProperties(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alicetable"), (Map)ImmutableMap.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableProperties(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), (Map)ImmutableMap.of()), SET_TABLE_PROPERTIES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testCanSetUserOperations() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-catalog_principal.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(Optional.empty(), alice.getUser()), "Principal null cannot become user alice");
        accessControl.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
        accessControl.checkCanSetUser(kerberosValidNonAsciiUser.getPrincipal(), kerberosValidNonAsciiUser.getUser());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(kerberosInvalidAlice.getPrincipal(), kerberosInvalidAlice.getUser()), "Principal mallory/example.com@EXAMPLE.COM cannot become user alice");
        accessControl.checkCanSetUser(kerberosValidShare.getPrincipal(), kerberosValidShare.getUser());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(kerberosInValidShare.getPrincipal(), kerberosInValidShare.getUser()), "Principal invalid/example.com@EXAMPLE.COM cannot become user alice");
        accessControl.checkCanSetUser(validSpecialRegexWildDot.getPrincipal(), validSpecialRegexWildDot.getUser());
        accessControl.checkCanSetUser(validSpecialRegexEndQuote.getPrincipal(), validSpecialRegexEndQuote.getUser());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(invalidSpecialRegex.getPrincipal(), invalidSpecialRegex.getUser()), "Principal special/.*@EXAMPLE.COM cannot become user alice");
        SystemAccessControl accessControlNoPatterns = this.newFileBasedSystemAccessControl("file-based-system-catalog.json");
        accessControlNoPatterns.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
    }

    @Test
    public void testQuery() {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("query.json");
        accessControlManager.checkCanExecuteQuery(ADMIN);
        accessControlManager.checkCanViewQueryOwnedBy(ADMIN, any);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(ADMIN, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
        accessControlManager.checkCanKillQueryOwnedBy(ADMIN, any);
        accessControlManager.checkCanExecuteQuery(ALICE);
        accessControlManager.checkCanViewQueryOwnedBy(ALICE, any);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(ALICE, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(ALICE, any), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanExecuteQuery(BOB), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(BOB, any), "Cannot view query");
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(BOB, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of());
        accessControlManager.checkCanKillQueryOwnedBy(BOB, any);
        accessControlManager.checkCanExecuteQuery(new SystemSecurityContext(dave, queryId));
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), alice);
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), dave);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), (Set)ImmutableSet.of((Object)"alice", (Object)"bob", (Object)"dave", (Object)"admin")), (Set)ImmutableSet.of((Object)"alice", (Object)"dave"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(dave, queryId), alice), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(dave, queryId), bob), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), bob), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), admin), "Cannot view query");
        Identity contractor = Identity.forUser((String)"some-other-contractor").withGroups((Set)ImmutableSet.of((Object)"contractors")).build();
        accessControlManager.checkCanExecuteQuery(new SystemSecurityContext(contractor, queryId));
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(contractor, queryId), dave);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(contractor, queryId), dave), "Cannot view query");
        accessControlManager.checkCanExecuteQuery(new SystemSecurityContext(nonAsciiUser, queryId));
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(nonAsciiUser, queryId), any);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(new SystemSecurityContext(nonAsciiUser, queryId), (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
        accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(nonAsciiUser, queryId), any);
    }

    @Test
    public void testInvalidQuery() {
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("query-invalid.json")).rootCause().hasMessage("A valid query rule cannot combine an queryOwner condition with access mode 'execute'");
    }

    @Test
    public void testQueryNotSet() {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("file-based-system-catalog.json");
        accessControlManager.checkCanExecuteQuery(BOB);
        accessControlManager.checkCanViewQueryOwnedBy(BOB, any);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(BOB, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
        accessControlManager.checkCanKillQueryOwnedBy(BOB, any);
    }

    @Test
    public void testQueryDocsExample() {
        File rulesFile = new File("../../docs/src/main/sphinx/security/query-access.json");
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        accessControlManager.checkCanExecuteQuery(ADMIN);
        accessControlManager.checkCanViewQueryOwnedBy(ADMIN, any);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(ADMIN, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
        accessControlManager.checkCanKillQueryOwnedBy(ADMIN, any);
        accessControlManager.checkCanExecuteQuery(ALICE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(ALICE, any), "Cannot view query");
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(ALICE, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of());
        accessControlManager.checkCanKillQueryOwnedBy(ALICE, any);
        accessControlManager.checkCanExecuteQuery(BOB);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(BOB, any), "Cannot view query");
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(BOB, (Set)ImmutableSet.of((Object)"a", (Object)"b")), (Set)ImmutableSet.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(BOB, any), "Cannot view query");
        accessControlManager.checkCanExecuteQuery(new SystemSecurityContext(dave, queryId));
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), alice);
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), dave);
        Assert.assertEquals((Set)accessControlManager.filterViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), (Set)ImmutableSet.of((Object)"alice", (Object)"bob", (Object)"dave", (Object)"admin")), (Set)ImmutableSet.of((Object)"alice", (Object)"dave"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(dave, queryId), alice), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(dave, queryId), bob), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), bob), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(dave, queryId), admin), "Cannot view query");
        Identity contractor = Identity.forUser((String)"some-other-contractor").withGroups((Set)ImmutableSet.of((Object)"contractors")).build();
        accessControlManager.checkCanExecuteQuery(new SystemSecurityContext(contractor, queryId));
        accessControlManager.checkCanViewQueryOwnedBy(new SystemSecurityContext(contractor, queryId), dave);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(new SystemSecurityContext(contractor, queryId), dave), "Cannot view query");
    }

    @Test
    public void testSystemInformation() {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("system-information.json");
        accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(admin, Optional.empty()));
        accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(admin, Optional.empty()));
        accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(alice, Optional.empty()));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(alice, Optional.empty())), "Cannot write system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(bob, Optional.empty())), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(bob, Optional.empty())), "Cannot write system information");
        accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(nonAsciiUser, Optional.empty()));
        accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(nonAsciiUser, Optional.empty()));
    }

    @Test
    public void testSystemInformationNotSet() {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("file-based-system-catalog.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(bob, Optional.empty())), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(bob, Optional.empty())), "Cannot write system information");
    }

    @Test
    public void testSystemInformationDocsExample() {
        File rulesFile = new File("../../docs/src/main/sphinx/security/system-information-access.json");
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(admin, Optional.empty()));
        accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(admin, Optional.empty()));
        accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(alice, Optional.empty()));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(alice, Optional.empty())), "Cannot write system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanReadSystemInformation(new SystemSecurityContext(bob, Optional.empty())), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(new SystemSecurityContext(bob, Optional.empty())), "Cannot write system information");
    }

    @Test
    public void testSessionPropertyRules() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-session-property.json");
        accessControl.checkCanSetSystemSessionProperty(ADMIN, "dangerous");
        accessControl.checkCanSetSystemSessionProperty(ADMIN, "any");
        accessControl.checkCanSetSystemSessionProperty(ALICE, "safe");
        accessControl.checkCanSetSystemSessionProperty(ALICE, "unsafe");
        accessControl.checkCanSetSystemSessionProperty(ALICE, "staff");
        accessControl.checkCanSetSystemSessionProperty(BOB, "safe");
        accessControl.checkCanSetSystemSessionProperty(BOB, "staff");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(BOB, "unsafe"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(ALICE, "dangerous"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(CHARLIE, "safe"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(CHARLIE, "staff"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(JOE, "staff"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "any", "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "alice-catalog", "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "any", "any");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "alice-catalog", "safe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "alice-catalog", "unsafe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "staff-catalog", "staff");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "bob-catalog", "safe");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "staff-catalog", "staff");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "bob-catalog", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "alice-catalog", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "staff-catalog", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(ALICE, "alice-catalog", "dangerous"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "bob-catalog", "safe"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "staff-catalog", "staff"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(JOE, "staff-catalog", "staff"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSessionPropertyDocsExample() {
        File rulesFile = new File("../../docs/src/main/sphinx/security/session-property-access.json");
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        SystemSecurityContext bannedUser = new SystemSecurityContext(Identity.ofUser((String)"banned_user"), queryId);
        accessControl.checkCanSetSystemSessionProperty(ADMIN, "any");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(ALICE, "any"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(bannedUser, "any"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetSystemSessionProperty(ADMIN, "resource_overcommit");
        accessControl.checkCanSetSystemSessionProperty(ALICE, "resource_overcommit");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(bannedUser, "resource_overcommit"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "hive", "any");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(ALICE, "hive", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(bannedUser, "hive", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "hive", "bucket_execution_enabled");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "hive", "bucket_execution_enabled");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(bannedUser, "hive", "bucket_execution_enabled"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFilterCatalogs() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        ImmutableSet allCatalogs = ImmutableSet.of((Object)"alice-catalog", (Object)"bob-catalog", (Object)"specific-catalog", (Object)"secret", (Object)"hidden", (Object)"open-to-all", (Object[])new String[]{"blocked-catalog", "unknown", "ptf-catalog"});
        Assert.assertEquals((Set)accessControl.filterCatalogs(ADMIN, (Set)allCatalogs), (Set)Sets.difference((Set)allCatalogs, (Set)ImmutableSet.of((Object)"blocked-catalog")));
        ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"specific-catalog", (Object)"alice-catalog", (Object)"ptf-catalog");
        Assert.assertEquals((Set)accessControl.filterCatalogs(ALICE, (Set)allCatalogs), (Set)aliceCatalogs);
        ImmutableSet bobCatalogs = ImmutableSet.of((Object)"specific-catalog", (Object)"alice-catalog", (Object)"bob-catalog");
        Assert.assertEquals((Set)accessControl.filterCatalogs(BOB, (Set)allCatalogs), (Set)bobCatalogs);
        ImmutableSet charlieCatalogs = ImmutableSet.of((Object)"specific-catalog");
        Assert.assertEquals((Set)accessControl.filterCatalogs(CHARLIE, (Set)allCatalogs), (Set)charlieCatalogs);
    }

    @Test
    public void testSchemaRulesForCheckCanShowSchemas() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanShowSchemas(ADMIN, "specific-catalog");
        accessControl.checkCanShowSchemas(ADMIN, "session-catalog");
        accessControl.checkCanShowSchemas(ADMIN, "secret");
        accessControl.checkCanShowSchemas(ADMIN, "hidden");
        accessControl.checkCanShowSchemas(ADMIN, "open-to-all");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ADMIN, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowSchemas(ADMIN, "unknown");
        accessControl.checkCanShowSchemas(ALICE, "specific-catalog");
        accessControl.checkCanShowSchemas(ALICE, "session-catalog");
        accessControl.checkCanShowSchemas(ALICE, "alice-catalog");
        accessControl.checkCanShowSchemas(ALICE, "alice-catalog-session");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "bob-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "bob-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "secret"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "hidden"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "open-to-all"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "unknown"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowSchemas(BOB, "specific-catalog");
        accessControl.checkCanShowSchemas(BOB, "session-catalog");
        accessControl.checkCanShowSchemas(BOB, "bob-catalog");
        accessControl.checkCanShowSchemas(BOB, "bob-catalog-session");
        accessControl.checkCanShowSchemas(BOB, "alice-catalog");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "alice-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "secret"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "hidden"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "open-to-all"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "unknown"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowSchemas(CHARLIE, "session-catalog");
        accessControl.checkCanShowSchemas(CHARLIE, "specific-catalog");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "alice-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "alice-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "bob-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "bob-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "secret"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "hidden"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "open-to-all"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "unknown"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFilterSchemas() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"specific-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"specific-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"specific-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"alice-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"bob-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"bob-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "secret", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of((Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "secret", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "secret", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "secret", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "hidden", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of((Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "hidden", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "hidden", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "hidden", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "open-to-all", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of((Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "open-to-all", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "open-to-all", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "open-to-all", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "unknown", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of((Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "unknown", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "unknown", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "unknown", (Set)ImmutableSet.of((Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown")), (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema")), (Set)ImmutableSet.of((Object)"ptf_schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema")), (Set)ImmutableSet.of((Object)"ptf_schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema")), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema")), (Set)ImmutableSet.of());
    }

    @Test
    public void testSchemaRulesForCheckCanShowTables() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("bob-catalog", "bob-schema"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("bob-catalog", "any"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("alice-catalog", "alice-schema"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("alice-catalog", "any"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("secret", "secret"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("hidden", "any"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("open-to-all", "any"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("unknown", "any"));
        accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("alice-catalog", "alice-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("bob-catalog", "bob-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("secret", "secret")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("hidden", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("open-to-all", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("unknown", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowTables(BOB, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowTables(BOB, new CatalogSchemaName("bob-catalog", "bob-schema"));
        accessControl.checkCanShowTables(BOB, new CatalogSchemaName("alice-catalog", "bob-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("bob-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("alice-catalog", "alice-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("alice-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("secret", "secret")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("hidden", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("open-to-all", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("unknown", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("specific-catalog", "specific-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("bob-catalog", "bob-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("bob-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("alice-catalog", "alice-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("alice-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("secret", "secret")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("hidden", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("open-to-all", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("unknown", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testGetColumnMask() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        Assert.assertEquals((Object)accessControl.getColumnMask(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), "masked", (Type)VarcharType.VARCHAR), Optional.empty());
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), "masked", (Type)VarcharType.VARCHAR).orElseThrow(), new ViewExpression(Optional.empty(), Optional.of("some-catalog"), Optional.of("bobschema"), "'mask'"));
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), "masked_with_user", (Type)VarcharType.VARCHAR).orElseThrow(), new ViewExpression(Optional.of("mask-user"), Optional.of("some-catalog"), Optional.of("bobschema"), "'mask-with-user'"));
    }

    @Test
    public void testGetRowFilter() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        Assert.assertEquals((Collection)accessControl.getRowFilters(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns")), (Collection)ImmutableList.of());
        List rowFilters = accessControl.getRowFilters(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"));
        Assert.assertEquals((int)rowFilters.size(), (int)1);
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), new ViewExpression(Optional.empty(), Optional.of("some-catalog"), Optional.of("bobschema"), "starts_with(value, 'filter')"));
        rowFilters = accessControl.getRowFilters(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"));
        Assert.assertEquals((int)rowFilters.size(), (int)1);
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), new ViewExpression(Optional.of("filter-user"), Optional.of("some-catalog"), Optional.of("bobschema"), "starts_with(value, 'filter-with-user')"));
    }

    private static void assertViewExpressionEquals(ViewExpression actual, ViewExpression expected) {
        Assert.assertEquals((Object)actual.getSecurityIdentity(), (Object)expected.getSecurityIdentity(), (String)"Identity");
        Assert.assertEquals((Object)actual.getCatalog(), (Object)expected.getCatalog(), (String)"Catalog");
        Assert.assertEquals((Object)actual.getSchema(), (Object)expected.getSchema(), (String)"Schema");
        Assert.assertEquals((String)actual.getExpression(), (String)expected.getExpression(), (String)"Expression");
    }

    @Test
    public void testFunctionRulesForCheckCanExecute() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ADMIN, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanExecuteFunction(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(BOB, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(CHARLIE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ADMIN, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_function")), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(ALICE, "some_function"), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanExecuteFunction(BOB, "some_function");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteFunction(CHARLIE, "some_function"), EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFunctionRulesForCheckCanGrantExecute() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, "some_function", new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, "some_function", new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, "some_function", new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true), GRANT_EXECUTE_FUNCTION_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, "some_function", new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, "some_function", new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, "some_function", new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true);
    }

    @Test
    public void testSchemaAuthorization() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("authorization.json");
        CatalogSchemaName schema = new CatalogSchemaName("some-catalog", "test");
        CatalogSchemaName ownedByUser = new CatalogSchemaName("some-catalog", "owned_by_user");
        CatalogSchemaName ownedByGroup = new CatalogSchemaName("some-catalog", "owned_by_group");
        CatalogSchemaName ownedByRole = new CatalogSchemaName("some-catalog", "owned_by_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "role"), schema, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.test to ROLE new_role");
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_authorized", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "authorized", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_without_authorization_access", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_DENY_authorized", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_user to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "DENY_authorized", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "DENY_authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_user to USER new_user");
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_group to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "DENY_authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_group to USER new_user");
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_role to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_DENY_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_role to USER new_user");
    }

    @Test
    public void testTableAuthorization() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("authorization.json");
        CatalogSchemaTableName table = new CatalogSchemaTableName("some-catalog", "test", "table");
        CatalogSchemaTableName ownedByUser = new CatalogSchemaTableName("some-catalog", "test", "owned_by_user");
        CatalogSchemaTableName ownedByGroup = new CatalogSchemaTableName("some-catalog", "test", "owned_by_group");
        CatalogSchemaTableName ownedByRole = new CatalogSchemaTableName("some-catalog", "test", "owned_by_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "role"), table, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.table to ROLE new_role");
        accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_authorized", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_without_authorization_access", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_DENY_authorized", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_user to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "DENY_authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_user to USER new_user");
        accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_group to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "DENY_authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_group to USER new_user");
        accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_role to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_DENY_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_role to USER new_user");
    }

    @Test
    public void testViewAuthorization() {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("authorization.json");
        CatalogSchemaTableName table = new CatalogSchemaTableName("some-catalog", "test", "table");
        CatalogSchemaTableName ownedByUser = new CatalogSchemaTableName("some-catalog", "test", "owned_by_user");
        CatalogSchemaTableName ownedByGroup = new CatalogSchemaTableName("some-catalog", "test", "owned_by_group");
        CatalogSchemaTableName ownedByRole = new CatalogSchemaTableName("some-catalog", "test", "owned_by_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "role"), table, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.table to ROLE new_role");
        accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_authorized", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_without_authorization_access", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_DENY_authorized", "group", "role"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_user to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "DENY_authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_user to USER new_user");
        accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "owner", "role"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_group to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "DENY_authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_group to USER new_user");
        accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "group", "owner"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_role to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_DENY_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), ownedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_role to USER new_user");
    }

    @Test
    public void testAuthorizationDocsExample() {
        File rulesFile = new File("../../docs/src/main/sphinx/security/authorization.json");
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        CatalogSchemaName schema = new CatalogSchemaName("catalog", "schema");
        CatalogSchemaTableName tableOrView = new CatalogSchemaTableName("catalog", "schema", "table_or_view");
        accessControlManager.checkCanSetSchemaAuthorization(ADMIN, schema, new TrinoPrincipal(PrincipalType.USER, "alice"));
        accessControlManager.checkCanSetSchemaAuthorization(ADMIN, schema, new TrinoPrincipal(PrincipalType.ROLE, "role"));
        accessControlManager.checkCanSetTableAuthorization(ADMIN, tableOrView, new TrinoPrincipal(PrincipalType.USER, "alice"));
        accessControlManager.checkCanSetTableAuthorization(ADMIN, tableOrView, new TrinoPrincipal(PrincipalType.ROLE, "role"));
        accessControlManager.checkCanSetViewAuthorization(ADMIN, tableOrView, new TrinoPrincipal(PrincipalType.USER, "alice"));
        accessControlManager.checkCanSetViewAuthorization(ADMIN, tableOrView, new TrinoPrincipal(PrincipalType.ROLE, "role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanSetSchemaAuthorization(ADMIN, schema, new TrinoPrincipal(PrincipalType.USER, "bob")), "Cannot set authorization for schema catalog.schema to USER bob");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanSetTableAuthorization(ADMIN, tableOrView, new TrinoPrincipal(PrincipalType.USER, "bob")), "Cannot set authorization for table catalog.schema.table_or_view to USER bob");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanSetViewAuthorization(ADMIN, tableOrView, new TrinoPrincipal(PrincipalType.USER, "bob")), "Cannot set authorization for view catalog.schema.table_or_view to USER bob");
    }

    private static SystemSecurityContext user(String user, String group, String role) {
        Identity identity = Identity.forUser((String)user).withGroups((Set)ImmutableSet.of((Object)group)).withEnabledRoles((Set)ImmutableSet.of((Object)role)).build();
        return new SystemSecurityContext(identity, queryId);
    }

    @Test
    public void parseUnknownRules() {
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("file-based-system-security-config-file-with-unknown-rules.json")).hasMessageContaining("Failed to convert JSON tree node");
    }

    @Test
    public void testTableRulesForCheckCanInsertIntoTableWithJsonPointer() {
        File configFile = new File(this.getResourcePath("file-based-system-access-table-with-json-pointer.json"));
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.json-pointer", (Object)"/data"));
        BaseFileBasedSystemAccessControlTest.assertTableRulesForCheckCanInsertIntoTable(accessControl);
    }

    protected SystemAccessControl newFileBasedSystemAccessControl(String rulesName) {
        File configFile = new File(this.getResourcePath(rulesName));
        return this.newFileBasedSystemAccessControl(configFile, (Map<String, String>)ImmutableMap.of());
    }

    protected SystemAccessControl newFileBasedSystemAccessControl(Map<String, String> config) {
        return new FileBasedSystemAccessControl.Factory().create(config);
    }

    protected String getResourcePath(String resourceName) {
        return Objects.requireNonNull(this.getClass().getClassLoader().getResource(resourceName), "Resource does not exist: " + resourceName).getPath();
    }

    private static void assertAccessDenied(ThrowableAssert.ThrowingCallable callable, String expectedMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(AccessDeniedException.class)).hasMessageMatching("Access Denied: " + expectedMessage);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$14(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test"), properties);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$13(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff"), properties);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$12(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob"), properties);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$11(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "test"), properties);
    }
}

