/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.stats.TDigest;
import io.airlift.units.Duration;
import io.trino.plugin.base.metrics.DurationTiming;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.spi.metrics.Metrics;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestMetrics {
    @Test
    public void testMergeCount() {
        Metrics m1 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new LongCount(1L), (Object)"b", (Object)new LongCount(2L)));
        Metrics m2 = new Metrics((Map)ImmutableMap.of((Object)"b", (Object)new LongCount(3L), (Object)"c", (Object)new LongCount(4L)));
        Metrics merged = TestMetrics.merge(m1, m2);
        ImmutableMap expectedMap = ImmutableMap.of((Object)"a", (Object)new LongCount(1L), (Object)"b", (Object)new LongCount(5L), (Object)"c", (Object)new LongCount(4L));
        Assertions.assertThat((Map)merged.getMetrics()).isEqualTo((Object)expectedMap);
    }

    @Test
    public void testMergeHistogram() {
        Metrics m1 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)TDigestHistogram.fromValue((double)10.0, (double)1.0)));
        Metrics m2 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)TDigestHistogram.fromValue((double)5.0, (double)2.0)));
        TDigestHistogram merged = (TDigestHistogram)TestMetrics.merge(m1, m2).getMetrics().get("a");
        Assertions.assertThat((long)merged.getTotal()).isEqualTo(3L);
        Assertions.assertThat((double)merged.getPercentile(0.0)).isEqualTo(5.0);
        Assertions.assertThat((double)merged.getPercentile(100.0)).isEqualTo(10.0);
        Assertions.assertThat((String)merged.toString()).matches((CharSequence)"\\{count=3, p01=5\\.00, p05=5\\.00, p10=5\\.00, p25=5\\.00, p50=7\\.50, p75=10\\.00, p90=10\\.00, p95=10\\.00, p99=10\\.00, min=5\\.00, max=10\\.00\\}");
    }

    @Test
    public void testDurationTiming() {
        DurationTiming d1 = new DurationTiming(new Duration(1234.0, TimeUnit.NANOSECONDS));
        DurationTiming d2 = new DurationTiming(new Duration(1.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((String)d1.toString()).matches((CharSequence)"\\{duration=1.23us\\}");
        Metrics m1 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)d1));
        Metrics m2 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)d2));
        DurationTiming merged = (DurationTiming)TestMetrics.merge(m1, m2).getMetrics().get("a");
        Assertions.assertThat((long)merged.getAirliftDuration().roundTo(TimeUnit.NANOSECONDS)).isEqualTo(1235L);
        Assertions.assertThat((long)merged.getDuration().toNanos()).isEqualTo(1235L);
        Assertions.assertThat((String)merged.toString()).matches((CharSequence)"\\{duration=1.24us\\}");
    }

    @Test
    public void testHistogramJson() {
        JsonCodec codec = JsonCodec.jsonCodec(TDigestHistogram.class);
        TDigest digest = new TDigest();
        digest.add(123.0);
        String json = codec.toJson((Object)new TDigestHistogram(digest));
        TDigestHistogram result = (TDigestHistogram)codec.fromJson(json);
        Assertions.assertThat((double)result.getDigest().getCount()).isEqualTo(digest.getCount());
    }

    @Test
    public void testDurationJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DurationTiming.class);
        DurationTiming duration = new DurationTiming(new Duration(123.0, TimeUnit.NANOSECONDS));
        String json = codec.toJson((Object)duration);
        DurationTiming result = (DurationTiming)codec.fromJson(json);
        Assertions.assertThat((Comparable)result.getAirliftDuration()).isEqualTo((Object)duration.getAirliftDuration());
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testFailIncompatibleTypes() {
        Metrics m1 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new TDigestHistogram(new TDigest())));
        Metrics m2 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new LongCount(0L)));
        TestMetrics.merge(m1, m2);
    }

    @Test
    public void testReduceSingleMetrics() {
        Metrics metrics = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new LongCount(0L)));
        Assertions.assertThat((Object)Metrics.accumulator().add(metrics).get()).isEqualTo((Object)metrics);
        Metrics metrics1 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new LongCount(1L)));
        Metrics metrics2 = new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new LongCount(2L)));
        Assertions.assertThat((Object)Metrics.accumulator().add(metrics1).add(metrics2).get()).isEqualTo((Object)new Metrics((Map)ImmutableMap.of((Object)"a", (Object)new LongCount(3L))));
    }

    private static Metrics merge(Metrics ... metrics) {
        return Arrays.stream(metrics).reduce(Metrics.EMPTY, Metrics::mergeWith);
    }
}

