/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.base.mapping.MappingConfig;
import io.trino.plugin.base.mapping.RuleBasedIdentifierMappingUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestMappingConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MappingConfig)ConfigAssertions.recordDefaults(MappingConfig.class)).setCaseInsensitiveNameMatching(false).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.MINUTES)).setCaseInsensitiveNameMatchingConfigFile(null).setCaseInsensitiveNameMatchingConfigFileRefreshPeriod(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws Exception {
        String configFile = RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile().toFile().getAbsolutePath();
        ImmutableMap properties = ImmutableMap.builder().put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.cache-ttl", (Object)"1s").put((Object)"case-insensitive-name-matching.config-file", (Object)configFile).put((Object)"case-insensitive-name-matching.config-file.refresh-period", (Object)"1s").buildOrThrow();
        MappingConfig expected = new MappingConfig().setCaseInsensitiveNameMatching(true).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.SECONDS)).setCaseInsensitiveNameMatchingConfigFile(configFile).setCaseInsensitiveNameMatchingConfigFileRefreshPeriod(new Duration(1.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

