/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.mapping;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.plugin.base.mapping.IdentifierMappingRules;
import io.trino.plugin.base.mapping.SchemaMappingRule;
import io.trino.plugin.base.mapping.TableMappingRule;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RuleBasedIdentifierMappingUtils {
    public static final Duration REFRESH_PERIOD_DURATION = Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.MILLISECONDS);

    private RuleBasedIdentifierMappingUtils() {
    }

    public static Path createRuleBasedIdentifierMappingFile() throws Exception {
        return RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile((List<SchemaMappingRule>)ImmutableList.of(), (List<TableMappingRule>)ImmutableList.of());
    }

    public static Path createRuleBasedIdentifierMappingFile(List<SchemaMappingRule> schemas, List<TableMappingRule> tables) throws Exception {
        Path file = Files.createTempFile("identifier-mapping-", ".json", new FileAttribute[0]);
        file.toFile().deleteOnExit();
        RuleBasedIdentifierMappingUtils.updateRuleBasedIdentifierMappingFile(file, schemas, tables);
        return file;
    }

    public static Path updateRuleBasedIdentifierMappingFile(Path file, List<SchemaMappingRule> schemas, List<TableMappingRule> tables) throws Exception {
        IdentifierMappingRules mapping = new IdentifierMappingRules(schemas, tables);
        String json = JsonCodec.jsonCodec(IdentifierMappingRules.class).toJson((Object)mapping);
        Files.write(file, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Thread.sleep(2L * REFRESH_PERIOD_DURATION.toMillis());
        return file;
    }
}

