/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

class ColumnPrinter {
    private static final int DEFAULT_MARGIN = 2;
    private final Collection<List<String>> data = new LinkedHashSet<List<String>>();
    private final List<String> columnNames;
    private final List<Integer> columnWidths;
    private final int margin;

    public ColumnPrinter(String ... columnNames) {
        this(2, columnNames);
    }

    public ColumnPrinter(int margin, String ... columnNames) {
        this.margin = margin;
        this.columnNames = ImmutableList.copyOf((Object[])columnNames);
        this.columnWidths = Arrays.stream(columnNames).map(String::length).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addValues(String ... values) {
        Preconditions.checkArgument((values.length == this.columnNames.size() ? 1 : 0) != 0, (Object)"wrong value count");
        for (int i = 0; i < values.length; ++i) {
            this.columnWidths.set(i, Math.max(values[i].length(), this.columnWidths.get(i)));
        }
        this.data.add((List<String>)ImmutableList.copyOf((Object[])values));
    }

    public List<String> generateOutput() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.printRow(this.columnNames));
        for (List<String> row : this.data) {
            lines.add(this.printRow(row));
        }
        return lines;
    }

    private String printRow(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            sb.append(ColumnPrinter.value(values.get(i), this.columnWidths.get(i) + this.margin));
        }
        return sb.toString().trim();
    }

    private static String value(String value, int width) {
        return value + Strings.repeat((String)" ", (int)(width - value.length()));
    }
}

