/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.log.Logging;
import io.airlift.log.LoggingMBean;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.guice.ExportBinder;

public class LogJmxModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(LoggingMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(LoggingMBean.class).as("io.airlift.log:name=Logging");
        binder.bind(LogExporter.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public Logging getLogging() {
        return Logging.initialize();
    }

    public static class LogExporter {
        private final Logging logging;

        @Inject
        public LogExporter(Logging logging, MBeanExporter exporter) {
            this.logging = Objects.requireNonNull(logging, "logging is null");
            logging.exportMBeans(Objects.requireNonNull(exporter, "exporter is null"));
        }

        @PreDestroy
        public void destroy() {
            this.logging.unexportMBeans();
        }
    }
}

