/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.rpc;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.HashSet;
import java.util.Set;

final class MetricsView {
    private static final Set<AttributeKey> alwaysInclude = MetricsView.buildAlwaysInclude();
    private static final Set<AttributeKey> clientView = MetricsView.buildClientView();
    private static final Set<AttributeKey> serverView = MetricsView.buildServerView();
    private static final Set<AttributeKey> serverFallbackView = MetricsView.buildServerFallbackView();

    private static Set<AttributeKey> buildAlwaysInclude() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>();
        view.add(SemanticAttributes.RPC_SYSTEM);
        view.add(SemanticAttributes.RPC_SERVICE);
        view.add(SemanticAttributes.RPC_METHOD);
        view.add(SemanticAttributes.RPC_GRPC_STATUS_CODE);
        view.add(NetworkAttributes.NETWORK_TYPE);
        view.add(NetworkAttributes.NETWORK_TRANSPORT);
        view.add(NetworkAttributes.SERVER_ADDRESS);
        view.add(NetworkAttributes.SERVER_PORT);
        view.add(NetworkAttributes.SERVER_SOCKET_ADDRESS);
        view.add(NetworkAttributes.SERVER_SOCKET_PORT);
        return view;
    }

    private static Set<AttributeKey> buildClientView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(alwaysInclude);
        view.add(SemanticAttributes.NET_PEER_NAME);
        view.add(SemanticAttributes.NET_PEER_PORT);
        view.add(SemanticAttributes.NET_TRANSPORT);
        return view;
    }

    private static Set<AttributeKey> buildServerView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(alwaysInclude);
        view.add(SemanticAttributes.NET_HOST_NAME);
        view.add(SemanticAttributes.NET_TRANSPORT);
        return view;
    }

    private static Set<AttributeKey> buildServerFallbackView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(alwaysInclude);
        view.add(SemanticAttributes.NET_SOCK_HOST_ADDR);
        view.add(SemanticAttributes.NET_TRANSPORT);
        return view;
    }

    private static <T> boolean containsAttribute(AttributeKey<T> key, Attributes startAttributes, Attributes endAttributes) {
        return startAttributes.get(key) != null || endAttributes.get(key) != null;
    }

    static Attributes applyClientView(Attributes startAttributes, Attributes endAttributes) {
        return MetricsView.applyView(clientView, startAttributes, endAttributes);
    }

    static Attributes applyServerView(Attributes startAttributes, Attributes endAttributes) {
        Set<AttributeKey> fullSet = serverView;
        if (!MetricsView.containsAttribute(SemanticAttributes.NET_HOST_NAME, startAttributes, endAttributes)) {
            fullSet = serverFallbackView;
        }
        return MetricsView.applyView(fullSet, startAttributes, endAttributes);
    }

    static Attributes applyView(Set<AttributeKey> view, Attributes startAttributes, Attributes endAttributes) {
        AttributesBuilder filtered = Attributes.builder();
        MetricsView.applyView(filtered, startAttributes, view);
        MetricsView.applyView(filtered, endAttributes, view);
        return filtered.build();
    }

    private static void applyView(AttributesBuilder filtered, Attributes attributes, Set<AttributeKey> view) {
        attributes.forEach((key, value) -> {
            if (view.contains(key)) {
                filtered.put(key, value);
            }
        });
    }

    private MetricsView() {
    }
}

