/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.util.DateTimeUtils;
import java.time.DateTimeException;
import java.util.OptionalInt;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestDateTimeUtils {
    @Test
    public void testParseIfIso8601DateFormat() {
        Assert.assertEquals((int)0, (int)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-01-01").getAsInt(), (String)"1970-01-01");
        Assert.assertEquals((int)31, (int)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02-01").getAsInt(), (String)"1970-02-01");
        Assert.assertEquals((int)-31, (int)DateTimeUtils.parseIfIso8601DateFormat((String)"1969-12-01").getAsInt(), (String)"1969-12-01");
        Assert.assertEquals((int)19051, (int)DateTimeUtils.parseIfIso8601DateFormat((String)"2022-02-28").getAsInt(), (String)"2022-02-28");
        Assert.assertEquals((int)-719528, (int)DateTimeUtils.parseIfIso8601DateFormat((String)"0000-01-01").getAsInt(), (String)"0000-01-01");
        Assert.assertEquals((int)2932896, (int)DateTimeUtils.parseIfIso8601DateFormat((String)"9999-12-31").getAsInt(), (String)"9999-12-31");
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-2-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"a970-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1p70-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"19%0-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"197o-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970_02-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970- 2-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-3.-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02/01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02-/1")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-12-0l")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970/02/01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"Dec 24 2022")).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DateTimeUtils.parseIfIso8601DateFormat((String)"2022-02-29")).isInstanceOf(DateTimeException.class)).hasMessage("Invalid date 'February 29' as '2022' is not a leap year");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DateTimeUtils.parseIfIso8601DateFormat((String)"1970-32-01")).isInstanceOf(DateTimeException.class)).hasMessage("Invalid value for MonthOfYear (valid values 1 - 12): 32");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02-41")).isInstanceOf(DateTimeException.class)).hasMessage("Invalid value for DayOfMonth (valid values 1 - 28/31): 41");
    }
}

