/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Throwables;
import io.trino.util.AutoCloseableCloser;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAutoCloseableCloser {
    @Test
    public void testEmpty() throws Exception {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        closer.close();
    }

    @Test
    public void testAllClosed() {
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.succeedingCloseable(), TestAutoCloseableCloser.succeedingCloseable());
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new RuntimeException()), TestAutoCloseableCloser.failingCloseable(new RuntimeException()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Exception()), TestAutoCloseableCloser.failingCloseable(new Exception()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Error()), TestAutoCloseableCloser.failingCloseable(new Error()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Throwable()), TestAutoCloseableCloser.failingCloseable(new Throwable()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Throwable()), TestAutoCloseableCloser.failingCloseable(new Throwable()), TestAutoCloseableCloser.failingCloseable(new Throwable()));
    }

    @Test
    public void testSuppressedException() {
        RuntimeException runtimeException = new RuntimeException();
        Exception exception = new Exception();
        Error error = new Error();
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(error));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(error));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(exception));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(exception));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(runtimeException));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(runtimeException));
        Assertions.assertThatThrownBy(() -> ((AutoCloseableCloser)closer).close()).isInstanceOfSatisfying(Exception.class, t -> {
            Assert.assertSame((Object)t, (Object)runtimeException);
            Assert.assertSame((Object)t.getSuppressed()[0], (Object)exception);
            Assert.assertSame((Object)t.getSuppressed()[1], (Object)exception);
            Assert.assertSame((Object)t.getSuppressed()[2], (Object)error);
            Assert.assertSame((Object)t.getSuppressed()[3], (Object)error);
        });
    }

    private static void assertAllClosed(TestAutoCloseable ... closeables) {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        for (TestAutoCloseable closeable : closeables) {
            closer.register((AutoCloseable)closeable);
        }
        try {
            closer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (TestAutoCloseable closeable : closeables) {
            Assert.assertTrue((boolean)closeable.isClosed());
        }
    }

    private static TestAutoCloseable succeedingCloseable() {
        return new TestAutoCloseable(null);
    }

    private static TestAutoCloseable failingCloseable(Throwable t) {
        return new TestAutoCloseable(t);
    }

    private static class TestAutoCloseable
    implements AutoCloseable {
        private final Throwable failure;
        private boolean closed;

        private TestAutoCloseable(Throwable failure) {
            this.failure = failure;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
            if (this.failure != null) {
                Throwables.propagateIfPossible((Throwable)this.failure, Exception.class);
                throw new AssertionError((Object)this.failure);
            }
        }
    }
}

