/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestCharType
extends AbstractTestType {
    private static final CharType CHAR_TYPE = CharType.createCharType((int)100);

    public TestCharType() {
        super((Type)CHAR_TYPE, String.class, TestCharType.createTestBlock());
    }

    public static Block createTestBlock() {
        VariableWidthBlockBuilder blockBuilder = CHAR_TYPE.createBlockBuilder(null, 15);
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "apple");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "apple");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "apple");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "banana");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "banana");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "banana");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "banana");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "banana");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "cherry");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "cherry");
        CHAR_TYPE.writeString((BlockBuilder)blockBuilder, "date");
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return Slices.utf8Slice((String)(((Slice)value).toStringUtf8() + "_"));
    }

    @Test
    public void testGetObjectValue() {
        CharType charType = CharType.createCharType((int)3);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)0, (Object)1, (Object)10, (Object)17, (Object)32, (Object)127, (Object)1011, (Object)11000, (Object)65891, (Object)65536, (Object)0x10FFFF).iterator();
        while (unmodifiableIterator.hasNext()) {
            int codePoint = (Integer)unmodifiableIterator.next();
            VariableWidthBlockBuilder blockBuilder = charType.createBlockBuilder(null, 1);
            Slice slice = codePoint != 32 ? SliceUtf8.codePointToUtf8((int)codePoint) : Slices.EMPTY_SLICE;
            blockBuilder.writeEntry(slice);
            Block block = blockBuilder.build();
            int codePointLengthInUtf16 = Character.isSupplementaryCodePoint(codePoint) ? 2 : 1;
            String objectValue = (String)charType.getObjectValue(TestingConnectorSession.SESSION, block, 0);
            Assert.assertNotNull((Object)objectValue);
            Assert.assertEquals((int)objectValue.codePointAt(0), (int)codePoint, (String)"first code point");
            Assert.assertEquals((int)objectValue.length(), (int)(codePointLengthInUtf16 + 2), (String)"size");
            for (int i = codePointLengthInUtf16; i < objectValue.length(); ++i) {
                Assert.assertEquals((int)objectValue.codePointAt(i), (int)32);
            }
        }
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)Slices.utf8Slice((String)Character.toString(0).repeat(((CharType)this.type).getLength())));
        Assert.assertEquals((Object)range.getMax(), (Object)Slices.utf8Slice((String)Character.toString(0x10FFFF).repeat(((CharType)this.type).getLength())));
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

