/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.CastDependency;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import java.lang.invoke.MethodHandle;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestCastDependencies {
    @Test
    public void testConventionDependencies() {
        try (QueryAssertions assertions = new QueryAssertions();){
            assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalar(CastVarcharToInteger.class).scalar(CastAnyToVarchar.class).scalar(CastAnyFromVarchar.class).build());
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.function("cast_varchar_to_integer", "'11'")))).isEqualTo(11);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.function("cast_any_to_varchar", "BIGINT '11'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("11");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.function("cast_any_to_varchar", "DATE '2005-05-05'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2005-05-05");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.function("cast_any_from_varchar", "DATE '2005-05-05'", "'2005-05-05'")))).isEqualTo(true);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.function("cast_any_from_varchar", "BIGINT '11'", "'12'")))).isEqualTo(false);
        }
    }

    @ScalarFunction(value="cast_varchar_to_integer")
    public static class CastVarcharToInteger {
        @SqlType(value="integer")
        public static long castVarcharToInteger(@CastDependency(fromType="varchar", toType="integer", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle cast, @SqlType(value="varchar") Slice value) {
            try {
                return cast.invokeExact(value);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    @ScalarFunction(value="cast_any_to_varchar")
    public static class CastAnyToVarchar {
        @TypeParameter(value="V")
        @SqlType(value="varchar")
        public static Slice castAnyToVarchar(@CastDependency(fromType="V", toType="varchar", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle cast, @SqlType(value="V") long value) {
            try {
                return cast.invokeExact(value);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    @ScalarFunction(value="cast_any_from_varchar")
    public static class CastAnyFromVarchar {
        @TypeParameter(value="V")
        @SqlType(value="boolean")
        public static boolean castAnyFromVarchar(@CastDependency(fromType="varchar", toType="V", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle cast, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"V", "V"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="V") long left, @SqlType(value="varchar") Slice right) {
            try {
                long rightLong = cast.invokeExact(right);
                return equals.invokeExact(left, rightLong);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }
}

