/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestBoundedVarcharType
extends AbstractTestType {
    public TestBoundedVarcharType() {
        super((Type)VarcharType.createVarcharType((int)6), String.class, TestBoundedVarcharType.createTestBlock(VarcharType.createVarcharType((int)6)));
    }

    private static Block createTestBlock(VarcharType type) {
        VariableWidthBlockBuilder blockBuilder = type.createBlockBuilder(null, 15);
        type.writeString((BlockBuilder)blockBuilder, "apple");
        type.writeString((BlockBuilder)blockBuilder, "apple");
        type.writeString((BlockBuilder)blockBuilder, "apple");
        type.writeString((BlockBuilder)blockBuilder, "banana");
        type.writeString((BlockBuilder)blockBuilder, "banana");
        type.writeString((BlockBuilder)blockBuilder, "banana");
        type.writeString((BlockBuilder)blockBuilder, "banana");
        type.writeString((BlockBuilder)blockBuilder, "banana");
        type.writeString((BlockBuilder)blockBuilder, "cherry");
        type.writeString((BlockBuilder)blockBuilder, "cherry");
        type.writeString((BlockBuilder)blockBuilder, "date");
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return Slices.utf8Slice((String)(((Slice)value).toStringUtf8() + "_"));
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)Slices.utf8Slice((String)""));
        Assert.assertEquals((Object)range.getMax(), (Object)Slices.utf8Slice((String)Character.toString(0x10FFFF).repeat(((VarcharType)this.type).getBoundedLength())));
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

