/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.DeterminismEvaluator;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.tree.QualifiedName;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeterminismEvaluator {
    @Test
    public void testDeterminismEvaluator() {
        TestingFunctionResolution functionResolution = new TestingFunctionResolution();
        CallExpression random = new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"random"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((RowExpression)random));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        ResolvedFunction lessThan = functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression lessThanExpression = new CallExpression(lessThan, (List)ImmutableList.of((Object)col0, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)DeterminismEvaluator.isDeterministic((RowExpression)lessThanExpression));
        CallExpression lessThanRandomExpression = new CallExpression(lessThan, (List)ImmutableList.of((Object)col0, (Object)random));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((RowExpression)lessThanRandomExpression));
    }
}

