/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.operator.scalar.TestStringFunctions;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestTrim {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestStringFunctions.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLeftTrim() {
        this.assertFunction("TRIM(LEADING FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(LEADING FROM '   ')", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(LEADING FROM '  hello  ')", "CAST('hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM '  hello')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING FROM 'hello  ')", "CAST('hello  ' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING FROM ' hello world ')", "CAST('hello world ' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING FROM '\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM ' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM '  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM ' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
    }

    @Test
    public void testCharLeftTrim() {
        this.assertFunction("TRIM(LEADING FROM CAST('' AS CHAR(20)))", "CAST('' AS VARCHAR(20))");
        this.assertFunction("TRIM(LEADING FROM CAST('' AS CHAR(20)))", "CAST('' AS VARCHAR(20))");
        this.assertFunction("TRIM(LEADING FROM CAST('  hello  ' AS CHAR(9)))", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM CAST('  hello' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING FROM CAST('hello  ' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING FROM CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING FROM CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING FROM CAST(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(10)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
    }

    @Test
    public void testRightTrim() {
        this.assertFunction("TRIM(TRAILING FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(TRAILING FROM '   ')", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(TRAILING FROM '  hello  ')", "CAST('  hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING FROM '  hello')", "CAST('  hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING FROM 'hello  ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING FROM ' hello world ')", "CAST(' hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(TRAILING FROM '\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(TRAILING FROM '\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING FROM ' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", "CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING FROM '  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
    }

    @Test
    public void testCharRightTrim() {
        this.assertFunction("TRIM(TRAILING FROM CAST('' AS CHAR(20)))", "CAST('' AS VARCHAR(20))");
        this.assertFunction("TRIM(TRAILING FROM CAST('  hello  ' AS CHAR(9)))", "CAST('  hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING FROM CAST('  hello' AS CHAR(7)))", "CAST('  hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING FROM CAST('hello  ' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING FROM CAST(' hello world ' AS CHAR(13)))", "CAST(' hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(TRAILING FROM CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ' AS CHAR(10)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(TRAILING FROM CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING FROM CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", "CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING FROM CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", "CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
    }

    @Test
    public void testLeftTrimParametrized() {
        this.assertFunction("TRIM(LEADING '' FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(LEADING '' FROM '   ')", "CAST('   ' AS VARCHAR(3))");
        this.assertFunction("TRIM(LEADING '' FROM '  hello  ')", "CAST('  hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING ' ' FROM '  hello  ')", "CAST('hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING CHAR ' ' FROM '  hello  ')", "CAST('hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING 'he ' FROM '  hello  ')", "CAST('llo  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING ' ' FROM '  hello')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING 'e h' FROM '  hello')", "CAST('llo' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING 'l' FROM 'hello  ')", "CAST('hello  ' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING ' ' FROM ' hello world ')", "CAST('hello world ' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING ' eh' FROM ' hello world ')", "CAST('llo world ' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING ' ehlowrd' FROM ' hello world ')", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING ' x' FROM ' hello world ')", "CAST('hello world ' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING '\u00f3\u017a' FROM '\u017a\u00f3\u0142\u0107')", "CAST('\u0142\u0107' AS VARCHAR(4))");
        this.assertInvalidFunction("TRIM(LEADING utf8(from_hex('3281')) FROM 'hello wolrd')", "Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testCharLeftTrimParametrized() {
        this.assertFunction("TRIM(LEADING '' FROM CAST('' AS CHAR(1)))", "CAST('' AS VARCHAR(1))");
        this.assertFunction("TRIM(LEADING '' FROM CAST('   ' AS CHAR(3)))", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(LEADING '' FROM CAST('  hello  ' AS CHAR(9)))", "CAST('  hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING ' ' FROM CAST('  hello  ' AS CHAR(9)))", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING 'he ' FROM CAST('  hello  ' AS CHAR(9)))", "CAST('llo' AS VARCHAR(9))");
        this.assertFunction("TRIM(LEADING ' ' FROM CAST('  hello' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING 'e h' FROM CAST('  hello' AS CHAR(7)))", "CAST('llo' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING 'l' FROM CAST('hello  ' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(LEADING ' ' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING ' eh' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('llo world' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING ' ehlowrd' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING ' x' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(LEADING '\u00f3\u017a' FROM CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4)))", "CAST('\u0142\u0107' AS VARCHAR(4))");
    }

    @Test
    public void testRightTrimParametrized() {
        this.assertFunction("TRIM(TRAILING '' FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(TRAILING '' FROM '   ')", "CAST('   ' AS VARCHAR(3))");
        this.assertFunction("TRIM(TRAILING '' FROM '  hello  ')", "CAST('  hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING ' ' FROM '  hello  ')", "CAST('  hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING 'lo ' FROM '  hello  ')", "CAST('  he' AS VARCHAR(9))");
        this.assertFunction("TRIM(TRAILING ' ' FROM 'hello  ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING 'l o' FROM 'hello  ')", "CAST('he' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING 'l' FROM 'hello  ')", "CAST('hello  ' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING ' ' FROM ' hello world ')", "CAST(' hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(TRAILING ' ld' FROM ' hello world ')", "CAST(' hello wor' AS VARCHAR(13))");
        this.assertFunction("TRIM(TRAILING ' ehlowrd' FROM ' hello world ')", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(TRAILING ' x' FROM ' hello world ')", "CAST(' hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(TRAILING 'def' FROM CAST('abc def' AS CHAR(7)))", "CAST('abc' AS VARCHAR(7))");
        this.assertFunction("TRIM(TRAILING '\u0107\u0142' FROM '\u017a\u00f3\u0142\u0107')", "CAST('\u017a\u00f3' AS VARCHAR(4))");
        this.assertInvalidFunction("TRIM(TRAILING utf8(from_hex('81')) FROM 'hello world')", "Invalid UTF-8 encoding in characters: \ufffd");
        this.assertInvalidFunction("TRIM(TRAILING utf8(from_hex('3281')) FROM 'hello world')", "Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testTrim() {
        this.assertFunction("TRIM('')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM('   ')", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM('  hello  ')", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM('  hello')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM('hello  ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(' hello world ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(BOTH FROM '   ')", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(BOTH FROM '  hello  ')", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM '  hello')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH FROM 'hello  ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH FROM ' hello world ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(' ' FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(' ' FROM '   ')", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(' ' FROM '  hello  ')", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(' ' FROM '  hello')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(' ' FROM 'hello  ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(' ' FROM ' hello world ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(BOTH FROM '\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(BOTH FROM '\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM ' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM '  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM ' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
    }

    @Test
    public void testCharTrim() {
        this.assertFunction("TRIM(CAST('' AS CHAR(20)))", "CAST('' AS VARCHAR(20))");
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)))", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST('  hello' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(CAST('hello  ' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH FROM CAST('' AS CHAR(20)))", "CAST('' AS VARCHAR(20))");
        this.assertFunction("TRIM(BOTH FROM CAST('  hello  ' AS CHAR(9)))", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM CAST('  hello' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH FROM CAST('hello  ' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH FROM CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ' AS CHAR(10)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(10)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(BOTH FROM CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ' AS CHAR(10)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
        this.assertFunction("TRIM(BOTH FROM CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH FROM CAST(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(10)))", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS VARCHAR(10))");
    }

    @Test
    public void testCharTrimParametrized() {
        this.assertFunction("TRIM(CAST('' AS CHAR(1)), '')", "CAST('' AS VARCHAR(1))");
        this.assertFunction("TRIM(CAST('   ' AS CHAR(3)), '')", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)), '')", "CAST('  hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)), ' ')", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)), 'he ')", "CAST('llo' AS VARCHAR(9))");
        this.assertFunction("TRIM(CAST('  hello' AS CHAR(7)), ' ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(CAST('  hello' AS CHAR(7)), 'e h')", "CAST('llo' AS VARCHAR(7))");
        this.assertFunction("TRIM(CAST('hello  ' AS CHAR(7)), 'l')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' eh')", "CAST('llo world' AS VARCHAR(13))");
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' ehlowrd')", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' x')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(CAST('abc def' AS CHAR(7)), 'def')", "CAST('abc' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH '' FROM CAST('' AS CHAR(1)))", "CAST('' AS VARCHAR(1))");
        this.assertFunction("TRIM(BOTH '' FROM CAST('   ' AS CHAR(3)))", "CAST('' AS VARCHAR(3))");
        this.assertFunction("TRIM(BOTH '' FROM CAST('  hello  ' AS CHAR(9)))", "CAST('  hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH ' ' FROM CAST('  hello  ' AS CHAR(9)))", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH 'he ' FROM CAST('  hello  ' AS CHAR(9)))", "CAST('llo' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH ' ' FROM CAST('  hello' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH 'e h' FROM CAST('  hello' AS CHAR(7)))", "CAST('llo' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH 'l' FROM CAST('hello  ' AS CHAR(7)))", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH ' ' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' eh' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('llo world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' ehlowrd' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' x' FROM CAST(' hello world ' AS CHAR(13)))", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH 'def' FROM CAST('abc def' AS CHAR(7)))", "CAST('abc' AS VARCHAR(7))");
        this.assertFunction("TRIM(CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4)), '\u017a\u0107\u0142')", "CAST('\u00f3' AS VARCHAR(4))");
        this.assertFunction("TRIM(BOTH '\u017a\u0107\u0142' FROM CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4)))", "CAST('\u00f3' AS VARCHAR(4))");
    }

    @Test
    public void testTrimParametrized() {
        this.assertFunction("TRIM('', '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM('   ', '')", "CAST('   ' AS VARCHAR(3))");
        this.assertFunction("TRIM('  hello  ', '')", "CAST('  hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM('  hello  ', ' ')", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM('  hello  ', 'he ')", "CAST('llo' AS VARCHAR(9))");
        this.assertFunction("TRIM('  hello  ', 'lo ')", "CAST('he' AS VARCHAR(9))");
        this.assertFunction("TRIM('  hello', ' ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM('hello  ', ' ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM('hello  ', 'l o')", "CAST('he' AS VARCHAR(7))");
        this.assertFunction("TRIM('hello  ', 'l')", "CAST('hello  ' AS VARCHAR(7))");
        this.assertFunction("TRIM(' hello world ', ' ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(' hello world ', ' ld')", "CAST('hello wor' AS VARCHAR(13))");
        this.assertFunction("TRIM(' hello world ', ' eh')", "CAST('llo world' AS VARCHAR(13))");
        this.assertFunction("TRIM(' hello world ', ' ehlowrd')", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(' hello world ', ' x')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH '' FROM '')", "CAST('' AS VARCHAR(0))");
        this.assertFunction("TRIM(BOTH '' FROM '   ')", "CAST('   ' AS VARCHAR(3))");
        this.assertFunction("TRIM(BOTH '' FROM '  hello  ')", "CAST('  hello  ' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH ' ' FROM '  hello  ')", "CAST('hello' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH 'he ' FROM '  hello  ')", "CAST('llo' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH 'lo ' FROM '  hello  ')", "CAST('he' AS VARCHAR(9))");
        this.assertFunction("TRIM(BOTH ' ' FROM '  hello')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH ' ' FROM 'hello  ')", "CAST('hello' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH 'l o' FROM 'hello  ')", "CAST('he' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH 'l' FROM 'hello  ')", "CAST('hello  ' AS VARCHAR(7))");
        this.assertFunction("TRIM(BOTH ' ' FROM ' hello world ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' ld' FROM ' hello world ')", "CAST('hello wor' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' eh' FROM ' hello world ')", "CAST('llo world' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' ehlowrd' FROM ' hello world ')", "CAST('' AS VARCHAR(13))");
        this.assertFunction("TRIM(BOTH ' x' FROM ' hello world ')", "CAST('hello world' AS VARCHAR(13))");
        this.assertFunction("TRIM('\u017a\u00f3\u0142\u0107', '\u0107\u017a')", "CAST('\u00f3\u0142' AS VARCHAR(4))");
        this.assertFunction("TRIM(BOTH '\u0107\u017a' FROM '\u017a\u00f3\u0142\u0107')", "CAST('\u00f3\u0142' AS VARCHAR(4))");
        this.assertFunction("CAST(TRIM(utf8(from_hex('81')), ' ') AS VARBINARY)", "x'81'");
        this.assertFunction("CAST(TRIM(CONCAT(utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", "x'81'");
        this.assertFunction("CAST(TRIM(CONCAT(' ', utf8(from_hex('81'))), ' ') AS VARBINARY)", "x'81'");
        this.assertFunction("CAST(TRIM(CONCAT(' ', utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", "x'81'");
        this.assertInvalidFunction("TRIM('hello world', utf8(from_hex('81')))", "Invalid UTF-8 encoding in characters: \ufffd");
        this.assertInvalidFunction("TRIM('hello world', utf8(from_hex('3281')))", "Invalid UTF-8 encoding in characters: 2\ufffd");
        this.assertInvalidFunction("TRIM(BOTH utf8(from_hex('3281')) FROM 'hello world')", "Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    private void assertFunction(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT " + actual)))).matches("SELECT " + expected);
    }

    private void assertInvalidFunction(@Language(value="SQL") String actual, String message) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT " + actual)).isInstanceOf(TrinoException.class)).hasMessage(message).extracting(e -> ((TrinoException)((Object)e)).getErrorCode().getCode()).isEqualTo((Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode());
    }
}

