/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestListagg {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testListaggQueryWithOneValue() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES 'a') t(value)")))).matches("VALUES (VARCHAR 'a')");
    }

    @Test
    public void testListaggQueryWithOneValueGrouping() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES (1, 'a')) t(id, value) GROUP BY id ORDER BY id ")))).matches("VALUES (1, VARCHAR 'a')");
    }

    @Test
    public void testListaggQueryWithMultipleValues() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', 'bb', 'ccc', 'dddd') t(value) ")))).matches("VALUES (VARCHAR 'a,bb,ccc,dddd')");
    }

    @Test
    public void testListaggQueryWithImplicitSeparator() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value) WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', 'b', 'c') t(value) ")))).matches("VALUES (VARCHAR 'abc')");
    }

    @Test
    public void testListaggQueryWithImplicitSeparatorGrouping() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value) WITHIN GROUP (ORDER BY value) FROM (VALUES          (1, 'c'),          (2, 'b'),          (1, 'a'),         (2, 'd')     )  t(id, value) GROUP BY id ORDER BY id ")))).matches("VALUES         (1, VARCHAR 'ac'),        (2, VARCHAR 'bd')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesOrderedDescending() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value DESC) FROM (VALUES 'a', 'bb', 'ccc', 'dddd') t(value) ")))).matches("VALUES (VARCHAR 'dddd,ccc,bb,a')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesMultipleSortItems() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY sortitem1, sortitem2) FROM (VALUES (2, 'C', 'ccc'), (2, 'B', 'bb'), (3, 'D', 'dddd'), (1, 'A', 'a')) t(sortitem1, sortitem2, value) ")))).matches("VALUES (VARCHAR 'a,bb,ccc,dddd')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesMultipleSortItemsGrouping() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value, ',') WITHIN GROUP (ORDER BY weight, label) FROM (VALUES (1, 200, 'C', 'ccc'), (1, 200, 'B', 'bb'), (2, 300, 'D', 'dddd'), (1, 100, 'A', 'a')) t(id, weight, label, value) GROUP BY id ORDER BY id ")))).matches("VALUES (1, VARCHAR 'a,bb,ccc'),        (2, VARCHAR 'dddd')");
    }

    @Test
    public void testListaggQueryWithFunctionExpression() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(upper(value), ' ') WITHIN GROUP (ORDER BY value) FROM (VALUES 'Trino', 'SQL', 'everything') t(value) ")))).matches("VALUES (VARCHAR 'SQL TRINO EVERYTHING')");
    }

    @Test
    public void testListaggQueryWithNullValues() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', NULL, 'bb', NULL, 'ccc', NULL, 'dddd', NULL) t(value) ")))).matches("VALUES (VARCHAR 'a,bb,ccc,dddd')");
    }

    @Test
    public void testListaggQueryWithNullValuesGrouping() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES              (1, 'a'),              (2, NULL),              (3, 'bb'),              (1, NULL),              (1, 'ccc'),              (2, NULL),              (3, 'dddd'),              (2, NULL)     ) t(id, value) GROUP BY id ORDER BY id ")))).matches("VALUES (1, VARCHAR 'a,ccc'),        (2, NULL),        (3, VARCHAR 'bb,dddd')");
    }

    @Test
    public void testListaggQueryIncorrectSyntax() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(v, ',') FROM (VALUES 'a') t(v)")).isInstanceOf(ParsingException.class)).hasMessage("line 1:24: mismatched input 'FROM'. Expecting: 'WITHIN'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(v) FROM (VALUES 'a') t(v)")).isInstanceOf(ParsingException.class)).hasMessage("line 1:19: mismatched input 'FROM'. Expecting: 'WITHIN'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(v, ',', '...') WITHIN GROUP (ORDER BY v)FROM (VALUES 'a') t(v)")).isInstanceOf(ParsingException.class)).hasMessage("line 1:22: mismatched input ','. Expecting: ')', 'ON'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(v, ',') WITHIN GROUP (ORDER BY v) OVER (PARTITION BY id)FROM (VALUES (1, 'a')) t(id, v)")).isInstanceOf(ParsingException.class)).hasMessage("line 1:55: mismatched input '('. Expecting: ',', 'EXCEPT', 'FETCH', 'FROM', 'GROUP', 'HAVING', 'INTERSECT', 'LIMIT', 'OFFSET', 'ORDER', 'UNION', 'WHERE', 'WINDOW', <EOF>");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(v, ',' ON OVERFLOW COLLAPSE) WITHIN GROUP (ORDER BY v)FROM (VALUES 'a') t(v)")).isInstanceOf(ParsingException.class)).hasMessage("line 1:35: mismatched input 'COLLAPSE'. Expecting: 'ERROR', 'TRUNCATE'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT LISTAGG(v, 123) WITHIN GROUP (ORDER BY v) FROM (VALUES 'Trino', 'SQL', 'everything') t(v) ")).isInstanceOf(ParsingException.class)).hasMessage("line 1:19: mismatched input '123'. Expecting: <string>");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT LISTAGG(v, ',' ON OVERFLOW TRUNCATE 1234567890 WITHOUT COUNT) WITHIN GROUP (ORDER BY v) FROM (VALUES 'Trino', 'SQL', 'everything') t(v) ")).isInstanceOf(ParsingException.class)).hasMessage("line 1:44: mismatched input '1234567890'. Expecting: 'WITH', 'WITHOUT', <string>");
    }

    @Test
    public void testListaggQueryIncorrectExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value)FROM (VALUES 1, NULL, 2, 3, 4) t(value)")).isInstanceOf(TrinoException.class)).hasMessage("line 1:8: Expected expression of varchar, but 'value' has integer type");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value)FROM (VALUES TRUE, NULL, FALSE, FALSE, TRUE) t(value)")).isInstanceOf(TrinoException.class)).hasMessage("line 1:8: Expected expression of varchar, but 'value' has boolean type");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value)FROM (VALUES array['abc', 'def'], array['sql']) t(value)")).isInstanceOf(TrinoException.class)).hasMessage("line 1:8: Expected expression of varchar, but 'value' has array(varchar(3)) type");
    }

    @Test
    public void testListaaggQueryIncorrectOrderByExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT listagg(label, ',') WITHIN GROUP (ORDER BY rgb) FROM (VALUES ('red', rgb(255, 0, 0)), ('green', rgb(0, 128, 0)), ('blue', rgb(0, 0, 255))) color(label, rgb) ")).isInstanceOf(TrinoException.class)).hasMessage("line 1:8: ORDER BY can only be applied to orderable types (actual: color)");
    }

    @Test
    public void testListaggQueryWithExplicitlyCastedNumericValues() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(try_cast(value as varchar), ',') WITHIN GROUP (ORDER BY value)FROM (VALUES 1, NULL, 2, 3, 4) t(value)")))).matches("VALUES (VARCHAR '1,2,3,4')");
    }

    @Test
    public void testListaggQueryWithDistinct() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg( DISTINCT value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES  'a', 'b', 'a', 'b', 'c', 'd', 'd', 'a', 'd', 'b', 'd') t(value)")))).matches("VALUES (VARCHAR 'a,b,c,d')");
    }

    @Test
    public void testListaggQueryWithDistinctGrouping() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, listagg( DISTINCT value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES            (1, 'a'),           (1, 'b'),           (1, 'a'),           (2, 'b'),           (1, 'c'),           (1, 'd'),           (2, 'd'),           (1, 'a'),           (2, 'd'),           (2, 'b'),           (1, 'd')    ) t(id, value) GROUP BY id ORDER BY id ")))).matches("VALUES (1, VARCHAR 'a,b,c,d'),        (2, VARCHAR 'b,d')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesWithDefaultSeparator() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT listagg(value) WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', 'bb', 'ccc', 'dddd') t(value) ")))).matches("VALUES (VARCHAR 'abbcccdddd')");
    }

    @Test
    public void testListaggQueryWithOrderingAndGrouping() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, LISTAGG(value, ',') WITHIN GROUP (ORDER BY value)           FROM (VALUES                    (1, 'a'),                    (1, 'b'),                    (2, 'd'),                    (2, 'c')                ) t(id, value)          GROUP BY id          ORDER BY id")))).matches("VALUES          (1, VARCHAR 'a,b'),     (2, VARCHAR 'c,d')");
    }

    @Test
    public void testListaggQueryOverflowError() {
        String tooLargeValue = "a".repeat(0x100000);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT LISTAGG(value, ',' ON OVERFLOW ERROR) WITHIN GROUP (ORDER BY value) FROM (VALUES '" + tooLargeValue + "','Trino') t(value) ")).isInstanceOf(TrinoException.class)).hasMessage("Concatenated string has the length in bytes larger than the maximum output length 1048576").matches(throwable -> ((TrinoException)((Object)throwable)).getErrorCode() == StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT.toErrorCode());
    }

    @Test
    public void testListaggQueryOverflowErrorGrouping() {
        String tooLargeValue = "a".repeat(0x100000);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT id, LISTAGG(value, ',' ON OVERFLOW ERROR) WITHIN GROUP (ORDER BY value) FROM (VALUES            (1, '" + tooLargeValue + "'),           (1, 'Trino'),           (2, 'SQL')     ) t(id, value) GROUP BY id ORDER BY id ")).isInstanceOf(TrinoException.class)).hasMessage("Concatenated string has the length in bytes larger than the maximum output length 1048576").matches(throwable -> ((TrinoException)((Object)throwable)).getErrorCode() == StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT.toErrorCode());
    }

    @Test
    public void testListaggQueryOverflowTruncateWithoutCountAndWithoutOverflowFiller() {
        String largeValue = "a".repeat(1048570);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT LISTAGG(value, ',' ON OVERFLOW TRUNCATE WITHOUT COUNT) WITHIN GROUP (ORDER BY value) FROM (VALUES '" + largeValue + "', 'trino', 'rocks') t(value) ")))).matches("VALUES (VARCHAR '" + largeValue + ",rocks,...')");
    }

    @Test
    public void testListaggQueryOverflowTruncateWithCountAndWithOverflowFiller() {
        String largeValue = "a".repeat(1048564);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT LISTAGG(value, ',' ON OVERFLOW TRUNCATE '.....' WITH COUNT) WITHIN GROUP (ORDER BY value) FROM (VALUES '" + largeValue + "', 'trino', 'sql', 'everything') t(value) ")))).matches("VALUES (VARCHAR '" + largeValue + ",everything,.....(2)')");
    }

    @Test
    public void testListaggQueryGroupingOverflowTruncateWithCountAndWithOverflowFiller() {
        String largeValue = "a".repeat(1048564);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT id, LISTAGG(value, ',' ON OVERFLOW TRUNCATE '.....' WITH COUNT) WITHIN GROUP (ORDER BY value) FROM (VALUES              (1, '" + largeValue + "'),              (1, 'trino'),              (1, 'sql'),              (1, 'everything'),              (2, 'listagg'),              (2, 'string joiner')      ) t(id, value) GROUP BY id ORDER BY id ")))).matches("VALUES    (1, VARCHAR '" + largeValue + ",everything,.....(2)'),   (2, VARCHAR 'listagg,string joiner')");
    }
}

