/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.json.PathEvaluationError;
import io.trino.operator.scalar.json.JsonInputConversionError;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.query.QueryAssertions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJsonExistsFunction {
    private static final String INPUT = "[\"a\", \"b\", \"c\"]";
    private static final String INCORRECT_INPUT = "[...";
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testJsonExists() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[1]')")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[1]')")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[100]')")))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]')")))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' TRUE ON ERROR)")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' FALSE ON ERROR)")))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' UNKNOWN ON ERROR)")))).matches("VALUES cast(null AS boolean)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'strict $[100]' ERROR ON ERROR)")).isInstanceOf(PathEvaluationError.class)).hasMessage("path evaluation failed: structural error: invalid array subscript: [100, 100] for array of size 3");
    }

    @Test
    public void testInputFormat() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[1]')")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]' FORMAT JSON, 'lax $[1]')")))).matches("VALUES true");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]' FORMAT JSON ENCODING UTF8, 'lax $[1]')")).hasMessage("line 1:20: Cannot read input of type varchar(15) as JSON using formatting JSON ENCODING UTF8");
        byte[] bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + ", 'lax $[1]')")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON, 'lax $[1]')")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]')")))).matches("VALUES true");
        bytes = INPUT.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF16, 'lax $[1]')")))).matches("VALUES true");
        bytes = INPUT.getBytes(Charset.forName("UTF-32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF32, 'lax $[1]')")))).matches("VALUES true");
        String finalVarbinaryLiteral = varbinaryLiteral;
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists(" + finalVarbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]' ERROR ON ERROR)")).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testInputConversionError() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'lax $[1]')")))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' TRUE ON ERROR)")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' FALSE ON ERROR)")))).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[...', 'strict $[1]' UNKNOWN ON ERROR)")))).matches("VALUES cast(null AS boolean)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists('[...', 'strict $[1]' ERROR ON ERROR)")).isInstanceOf(JsonInputConversionError.class)).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testPassingClause() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 2 AS number)")).hasMessage("line 1:39: no value passed for parameter number. Try quoting \"number\" in the PASSING clause to match case");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 5 AS \"number\")")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[1, 2, 3]' FORMAT JSON AS \"array\")")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\")")))).matches("VALUES false");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\" ERROR ON ERROR)")).isInstanceOf(JsonInputConversionError.class)).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $[$number]' PASSING 5 AS \"number\")")))).matches("VALUES false");
    }

    @Test
    public void testIncorrectPath() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'certainly not a valid path')")).isInstanceOf(ParsingException.class)).hasMessage("line 1:40: mismatched input 'certainly' expecting {'lax', 'strict'}");
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists(null, 'lax $')")))).matches("VALUES cast(null AS boolean)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null AS \"var\")")))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_exists('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null FORMAT JSON AS \"var\")")))).matches("VALUES false");
    }
}

