/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.rowpattern.ir.IrAlternation;
import io.trino.sql.planner.rowpattern.ir.IrAnchor;
import io.trino.sql.planner.rowpattern.ir.IrConcatenation;
import io.trino.sql.planner.rowpattern.ir.IrEmpty;
import io.trino.sql.planner.rowpattern.ir.IrExclusion;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrPermutation;
import io.trino.sql.planner.rowpattern.ir.IrQuantified;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.List;
import java.util.Optional;

public class Patterns {
    private Patterns() {
    }

    public static IrLabel label(String name) {
        return new IrLabel(name);
    }

    public static IrRowPattern empty() {
        return new IrEmpty();
    }

    public static IrRowPattern excluded(IrRowPattern pattern) {
        return new IrExclusion(pattern);
    }

    public static IrRowPattern start() {
        return new IrAnchor(IrAnchor.Type.PARTITION_START);
    }

    public static IrRowPattern end() {
        return new IrAnchor(IrAnchor.Type.PARTITION_END);
    }

    public static IrRowPattern plusQuantified(IrRowPattern pattern, boolean greedy) {
        return new IrQuantified(pattern, IrQuantifier.oneOrMore((boolean)greedy));
    }

    public static IrRowPattern starQuantified(IrRowPattern pattern, boolean greedy) {
        return new IrQuantified(pattern, IrQuantifier.zeroOrMore((boolean)greedy));
    }

    public static IrRowPattern questionMarkQuantified(IrRowPattern pattern, boolean greedy) {
        return new IrQuantified(pattern, IrQuantifier.zeroOrOne((boolean)greedy));
    }

    public static IrRowPattern rangeQuantified(IrRowPattern pattern, int atLeast, Optional<Integer> atMost, boolean greedy) {
        return new IrQuantified(pattern, new IrQuantifier(atLeast, atMost, greedy));
    }

    public static IrRowPattern alternation(IrRowPattern ... parts) {
        return new IrAlternation((List)ImmutableList.copyOf((Object[])parts));
    }

    public static IrRowPattern concatenation(IrRowPattern ... parts) {
        return new IrConcatenation((List)ImmutableList.copyOf((Object[])parts));
    }

    public static IrRowPattern permutation(IrRowPattern ... parts) {
        return new IrPermutation((List)ImmutableList.copyOf((Object[])parts));
    }
}

