/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.planprinter.CounterBasedAnonymizer;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestCounterBasedAnonymizer {
    @Test
    public void testTimestampWithTimeZoneValueAnonymization() {
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "2012-10-30 18:00:00.000 America/Los_Angeles")).isEqualTo("timestamp_3_with_time_zone_value_1");
    }

    @Test
    public void testSymbolReferenceAnonymization() {
        LogicalExpression expression = new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral("1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral("2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("c"), (Expression)new LongLiteral("3"))));
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Expression)expression)).isEqualTo("((\"symbol_1\" > 'long_literal_1') AND (\"symbol_2\" < 'long_literal_2') AND (\"symbol_3\" = 'long_literal_3'))");
    }

    @Test(dataProvider="literals")
    public void testLiteralAnonymization(Literal actual, String expected) {
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Expression)actual)).isEqualTo(expected);
    }

    @DataProvider
    public static Object[][] literals() {
        return new Object[][]{{new BinaryLiteral("DEF321"), "'binary_literal_1'"}, {new StringLiteral("abc"), "'string_literal_1'"}, {new GenericLiteral("bigint", "1"), "'bigint_literal_1'"}, {new CharLiteral("a"), "'char_literal_1'"}, {new DecimalLiteral("123"), "'decimal_literal_1'"}, {new DoubleLiteral(String.valueOf(6554)), "'double_literal_1'"}, {new DoubleLiteral(String.valueOf(Double.MAX_VALUE)), "'double_literal_1'"}, {new LongLiteral(String.valueOf(6554)), "'long_literal_1'"}, {new LongLiteral(String.valueOf(Long.MAX_VALUE)), "'long_literal_1'"}, {new BooleanLiteral("true"), "true"}, {new TimeLiteral("03:04:05"), "'time_literal_1'"}, {new TimestampLiteral("2012-10-31 01:00 UTC"), "'timestamp_literal_1'"}, {new NullLiteral(), "null"}, {new IntervalLiteral("33", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty()), "'interval_literal_1'"}};
    }
}

