/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.TopNRankingSymbolMatcher;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestWindowFilterPushDown
extends BasePlanTest {
    private static final String ROW_NUMBER_FUNCTION_NAME = "row_number";
    private static final String RANK_FUNCTION_NAME = "rank";

    @Test
    public void testLimitAbovePartitionedWindow() {
        this.assertLimitAbovePartitionedWindow(ROW_NUMBER_FUNCTION_NAME, TopNRankingNode.RankingType.ROW_NUMBER);
        this.assertLimitAbovePartitionedWindow(RANK_FUNCTION_NAME, TopNRankingNode.RankingType.RANK);
    }

    private void assertLimitAbovePartitionedWindow(String rankingFunction, TopNRankingNode.RankingType rankingType) {
        String sql = String.format("SELECT %s() OVER (PARTITION BY suppkey ORDER BY orderkey) partition_row_number FROM lineitem LIMIT 10", rankingFunction);
        this.assertPlanWithSession(sql, this.optimizeTopNRanking(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(rankingType).maxRankingPerPartition(10), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
        this.assertPlanWithSession(sql, this.optimizeTopNRanking(false), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
    }

    @Test
    public void testLimitAboveUnpartitionedWindow() {
        this.assertPlanWithSession("SELECT row_number() OVER (ORDER BY orderkey) partition_row_number FROM lineitem LIMIT 10", this.optimizeTopNRanking(true), true, PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(TopNRankingNode.RankingType.ROW_NUMBER).maxRankingPerPartition(10), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem"))))));
        this.assertPlanWithSession("SELECT rank() OVER (ORDER BY orderkey) partition_row_number FROM lineitem LIMIT 10", this.optimizeTopNRanking(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(TopNRankingNode.RankingType.RANK).maxRankingPerPartition(10), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
    }

    @Test
    public void testFilterAboveWindow() {
        this.assertFilterAboveWindow(ROW_NUMBER_FUNCTION_NAME, TopNRankingNode.RankingType.ROW_NUMBER);
        this.assertFilterAboveWindow(RANK_FUNCTION_NAME, TopNRankingNode.RankingType.RANK);
    }

    private void assertFilterAboveWindow(String rankingFunction, TopNRankingNode.RankingType rankingType) {
        String sql = String.format("SELECT * FROM (SELECT %s() OVER (PARTITION BY suppkey ORDER BY orderkey) partition_ranking FROM lineitem) WHERE partition_ranking < 10", rankingFunction);
        this.assertPlanWithSession(sql, this.optimizeTopNRanking(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(rankingType).maxRankingPerPartition(9), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem"))))));
        this.assertPlanWithSession(sql, this.optimizeTopNRanking(false), true, PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
        this.assertPlanWithSession(String.format("SELECT * FROM (SELECT name, %s() OVER(ORDER BY name) FROM nation) t(name, ranking) WHERE ranking < 0", rankingFunction), this.optimizeTopNRanking(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"ranking"), PlanMatchPattern.values("name", "ranking")));
        this.assertPlanWithSession(String.format("SELECT * FROM (SELECT name, %s() OVER(ORDER BY name) FROM nation) t(name, ranking) WHERE ranking > 0 AND ranking < 2", rankingFunction), this.optimizeTopNRanking(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"ranking"), PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(rankingType).maxRankingPerPartition(1).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher())));
        this.assertPlanWithSession(String.format("SELECT * FROM (SELECT name, %s() OVER(ORDER BY name) FROM nation) t(name, ranking) WHERE ranking <= 1", rankingFunction), this.optimizeTopNRanking(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"ranking"), PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(rankingType).maxRankingPerPartition(1).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher())));
        this.assertPlanWithSession(String.format("SELECT * FROM (SELECT name, %s() OVER(ORDER BY name) FROM nation) t(name, ranking) WHERE ranking <= 1 AND ranking > -10", rankingFunction), this.optimizeTopNRanking(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"ranking"), PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(rankingType).maxRankingPerPartition(1).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher())));
        this.assertPlanWithSession(String.format("SELECT * FROM (SELECT name, %s() OVER(ORDER BY name) FROM nation) t(name, ranking) WHERE ranking > 1 AND ranking < 3", rankingFunction), this.optimizeTopNRanking(true), true, PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)"ranking"), PlanMatchPattern.filter("(ranking > BIGINT '1') AND (ranking < BIGINT '3')", PlanMatchPattern.topNRanking(pattern -> pattern.rankingType(rankingType).maxRankingPerPartition(2).specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"name", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher()))));
    }

    @Test
    public void testFilterAboveRowNumber() {
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number < 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)ROW_NUMBER_FUNCTION_NAME), PlanMatchPattern.values("name", ROW_NUMBER_FUNCTION_NAME)));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number < 2", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)ROW_NUMBER_FUNCTION_NAME), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(1)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias(ROW_NUMBER_FUNCTION_NAME, (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number <= 1", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)ROW_NUMBER_FUNCTION_NAME), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(1)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias(ROW_NUMBER_FUNCTION_NAME, (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number <= 1 AND row_number > -10", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)ROW_NUMBER_FUNCTION_NAME), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(1)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias(ROW_NUMBER_FUNCTION_NAME, (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.assertPlan("SELECT * FROM (SELECT name, row_number() OVER() FROM nation) t(name, row_number) WHERE row_number > 1 AND row_number < 3", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"name", (Object)ROW_NUMBER_FUNCTION_NAME), PlanMatchPattern.filter("(row_number > BIGINT '1') AND (row_number < BIGINT '3')", PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias(ROW_NUMBER_FUNCTION_NAME, (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    private Session optimizeTopNRanking(boolean enabled) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_top_n_ranking", Boolean.toString(enabled)).build();
    }
}

