/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SymbolReference;
import java.util.Collections;
import org.junit.jupiter.api.Test;

public class TestTransformUncorrelatedInPredicateSubqueryToSemiJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedInPredicateSubqueryToSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNoCorrelation() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of(), Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNonInPredicateSubquery() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("x"), (Expression)new ExistsPredicate((Expression)new LongLiteral("1"))), Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testFiresForInPredicate() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedInPredicateSubqueryToSemiJoin()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("x"), (Expression)new InPredicate((Expression)new SymbolReference("y"), (Expression)new SymbolReference("z"))), Collections.emptyList(), (PlanNode)p.values(p.symbol("y")), (PlanNode)p.values(p.symbol("z")))).matches(PlanMatchPattern.node(SemiJoinNode.class, PlanMatchPattern.values("y"), PlanMatchPattern.values("z")));
    }
}

