/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.NullLiteral;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestReplaceRedundantJoinWithProject
extends BaseRuleTest {
    public TestReplaceRedundantJoinWithProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnInnerJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenOuterSourceEmpty() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnFullJoinWithBothSourcesEmpty() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testReplaceLeftJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("CAST(null AS bigint)")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral())))));
    }

    @Test
    public void testReplaceRightJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("CAST(null AS bigint)"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral())))));
    }

    @Test
    public void testReplaceFULLJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("CAST(null AS bigint)")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral())))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("CAST(null AS bigint)"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral())))));
    }
}

