/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveUnreferencedScalarSubqueries;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveUnreferencedScalarSubqueries
extends BaseRuleTest {
    public TestRemoveUnreferencedScalarSubqueries() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveUnreferencedInput() {
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())), (PlanNode)p.values(2, b));
        }).matches(PlanMatchPattern.values("b"));
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(2, b));
        }).matches(PlanMatchPattern.values("b"));
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())), CorrelatedJoinNode.Type.RIGHT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(2, b));
        }).matches(PlanMatchPattern.values("b"));
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())), CorrelatedJoinNode.Type.FULL, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(2, b));
        }).matches(PlanMatchPattern.values("b"));
    }

    @Test
    public void testDoNotRemoveInputOfLeftOrFullJoinWhenSubqueryPotentiallyEmpty() {
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new LongLiteral("3")), (PlanNode)p.values(2, b)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())), CorrelatedJoinNode.Type.FULL, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new LongLiteral("3")), (PlanNode)p.values(2, b)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotRemoveInputWhenCorrelationPresent() {
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(1, a), (PlanNode)p.values(2, b));
        }).doesNotFire();
    }

    @Test
    public void testRemoveUnreferencedSubquery() {
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT)), (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())))).matches(PlanMatchPattern.values("b"));
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT)), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())))).matches(PlanMatchPattern.values("b"));
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT)), CorrelatedJoinNode.Type.RIGHT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())))).matches(PlanMatchPattern.values("b"));
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT)), CorrelatedJoinNode.Type.FULL, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())))).matches(PlanMatchPattern.values("b"));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveUnreferencedScalarSubqueries()).on(p -> p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }
}

