/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantOffset;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantOffset
extends BaseRuleTest {
    public TestRemoveRedundantOffset() {
        super(new Plugin[0]);
    }

    @Test
    public void testOffsetEqualToSubplanCardinality() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantOffset()).on(p -> p.offset(10L, (PlanNode)p.values(10, new Symbol[0]))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()));
    }

    @Test
    public void testOffsetExceedsSubplanCardinality() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantOffset()).on(p -> p.offset(10L, (PlanNode)p.values(5, new Symbol[0]))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()));
    }

    @Test
    public void testOffsetEqualToZero() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantOffset()).on(p -> p.offset(0L, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("1")), (Object)ImmutableList.of((Object)PlanBuilder.expression("2")))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("1")), (Object)ImmutableList.of((Object)PlanBuilder.expression("2")))));
    }

    @Test
    public void testDoNotFireWhenOffsetLowerThanSubplanCardinality() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantOffset()).on(p -> p.offset(5L, (PlanNode)p.values(10, new Symbol[0]))).doesNotFire();
    }
}

