/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoRowNumber;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushdownFilterIntoRowNumber
extends BaseRuleTest {
    public TestPushdownFilterIntoRowNumber() {
        super(new Plugin[0]);
    }

    @Test
    public void testSourceRowNumber() {
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("row_number_1 < cast(100 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(99)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("row_number_1 < cast(100 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(10), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(10)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("cast(3 as bigint) < row_number_1 and row_number_1 < cast(5 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(10), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.filter("cast(3 as bigint) < row_number_1 and row_number_1 < cast(5 as bigint)", PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(4)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")).withAlias("row_number_1", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("row_number_1 < cast(5 as bigint) and a = BIGINT '1'"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(10), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.filter("a = BIGINT '1'", PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(4)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")).withAlias("row_number_1", (RvalueMatcher)new RowNumberSymbolMatcher())));
    }

    @Test
    public void testNoOutputsThroughRowNumber() {
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("row_number_1 < cast(-100 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(p.symbol("a"))));
        }).matches(PlanMatchPattern.values("a", "row_number_1"));
    }

    @Test
    public void testDoNotFire() {
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("not_row_number < cast(100 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(p.symbol("a"), p.symbol("not_row_number"))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("row_number_1 > cast(100 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(p.symbol("a"))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter(PlanBuilder.expression("cast(3 as bigint) < row_number_1 and row_number_1 < cast(5 as bigint)"), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(4), rowNumberSymbol, (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

