/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushTopNThroughProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushTopNThroughProject
extends BaseRuleTest {
    private static final RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));

    public TestPushTopNThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownTopNNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedB, (Expression)new SymbolReference("b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression("a"), (Object)"projectedB", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownTopNNonIdentityProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression("a"), (Object)"projectedC", (Object)PlanMatchPattern.expression("a + b")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownTopNThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushdownTopNThroughProjectionOverFilterOverTableScan() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a")), (PlanNode)p.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushdownTopNThroughProjectionOverTableScan() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)a), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)a, (Object)new TestingMetadata.TestingColumnHandle("a")))));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushDownTopNThroughExclusiveDereferences() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.project(Assignments.builder().put(p.symbol("b"), (Expression)new SubscriptExpression((Expression)a.toSymbolReference(), (Expression)new LongLiteral("1"))).put(p.symbol("c"), (Expression)new SubscriptExpression((Expression)a.toSymbolReference(), (Expression)new LongLiteral("2"))).build(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testPushTopNThroughOverlappingDereferences() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            Symbol d = p.symbol("d");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)d), (PlanNode)p.project(Assignments.builder().put(p.symbol("b"), (Expression)new SubscriptExpression((Expression)a.toSymbolReference(), (Expression)new LongLiteral("1"))).put(p.symbol("c", (Type)rowType), (Expression)a.toSymbolReference()).putIdentity(d).build(), (PlanNode)p.values(a, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("a[1]"), (Object)"c", (Object)PlanMatchPattern.expression("a"), (Object)"d", (Object)PlanMatchPattern.expression("d")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("d", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "d"))));
    }
}

