/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoRowNumber;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushPredicateThroughProjectIntoRowNumber
extends BaseRuleTest {
    public TestPushPredicateThroughProjectIntoRowNumber() {
        super(new Plugin[0]);
    }

    @Test
    public void testRowNumberSymbolPruned() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("a = 1"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNoUpperBoundForRowNumberSymbol() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("a = BIGINT '1'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNonPositiveUpperBoundForRowNumberSymbol() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("a = BIGINT '1' AND row_number < BIGINT '-10'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.values("a", "row_number"));
    }

    @Test
    public void testPredicateNotSatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number > BIGINT '2' AND row_number < BIGINT '5'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter("row_number > BIGINT '2' AND row_number < BIGINT '5'", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(4)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testPredicateNotSatisfiedAndMaxRowCountNotUpdated() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number > BIGINT '2' AND row_number < BIGINT '5'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testPredicateSatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < BIGINT '5'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < BIGINT '3'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
    }

    @Test
    public void testPredicatePartiallySatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < BIGINT '5' AND a > BIGINT '0'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber, a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter("a > BIGINT '0'", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number"), (Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < BIGINT '5' AND row_number % 2 = BIGINT '0'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter("row_number % 2 = BIGINT '0'", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }
}

