/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughUnion;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestPushLimitThroughUnion
extends BaseRuleTest {
    public TestPushLimitThroughUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushLimitThroughUnion() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.limit(1L, (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(10, a), (Object)p.values(10, b))));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.union(PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.values("a")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.values("b")))));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.limit(1L, (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.limit(1L, (PlanNode)p.values(5, a)), (Object)p.limit(1L, (PlanNode)p.values(5, b)))));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushLimitWithTies() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)c), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(10, a), (Object)p.values(10, b))));
        }).doesNotFire();
    }
}

