/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.PushCastIntoRow;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPushCastIntoRow
extends BaseRuleTest {
    public TestPushCastIntoRow() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.test("CAST(ROW(1) AS row(bigint))", "ROW(CAST(1 AS bigint))");
        this.test("CAST(ROW(1, 'a') AS row(bigint, varchar))", "ROW(CAST(1 AS bigint), CAST('a' AS varchar))");
        this.test("CAST(CAST(ROW(1, 'a') AS row(smallint, varchar)) AS ROW(bigint, varchar))", "ROW(CAST(CAST(1 AS smallint) AS bigint), CAST(CAST('a' AS varchar) AS varchar))");
        this.test("CAST(CAST(ROW(1, 'a') AS row(smallint, varchar)) AS ROW(x bigint, varchar))", "CAST(ROW(CAST(1 AS smallint), CAST('a' AS varchar)) AS ROW(x bigint, varchar))");
        this.test("CAST(CAST(ROW(1, 'a') AS row(a smallint, b varchar)) AS ROW(x bigint, varchar))", "CAST(ROW(CAST(1 AS smallint), CAST('a' AS varchar)) AS ROW(x bigint, varchar))");
        this.test("CAST(ROW(1) AS row(bigint))[1]", "ROW(CAST(1 AS bigint))[1]");
        this.test("CAST(ROW(NULL) AS row(unknown))", "ROW(NULL)");
    }

    private void test(String original, String unwrapped) {
        this.tester().assertThat(new PushCastIntoRow().projectExpressionRewrite()).on(p -> p.project(Assignments.builder().put(p.symbol("output"), PlanBuilder.expression(original)).build(), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.project(Map.of("output", PlanMatchPattern.expression(unwrapped)), PlanMatchPattern.values(new String[0])));
    }
}

