/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableFunctionProcessorColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneTableFunctionProcessorColumns
extends BaseRuleTest {
    public TestPruneTableFunctionProcessorColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotPruneProperOutputs() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(p.symbol("p")).source((PlanNode)p.values(p.symbol("x")))))).doesNotFire();
    }

    @Test
    public void testPrunePassThroughOutputs() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of(), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, true), (Object)new TableFunctionNode.PassThroughColumn(b, false)))).source((PlanNode)p.values(a, b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())), PlanMatchPattern.values("a", "b"))));
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> {
            Symbol proper = p.symbol("proper");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of(), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(proper).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, true), (Object)new TableFunctionNode.PassThroughColumn(b, false)))).source((PlanNode)p.values(a, b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"proper")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testReferencedPassThroughOutputs() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> {
            Symbol x = p.symbol("x");
            Symbol y = p.symbol("y");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{y, b}), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(x, y).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, true), (Object)new TableFunctionNode.PassThroughColumn(b, false)))).source((PlanNode)p.values(a, b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"y", (Object)PlanMatchPattern.expression("y"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"x", (Object)"y")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b"))), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testAllPassThroughOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, true), (Object)new TableFunctionNode.PassThroughColumn(b, false)))).source((PlanNode)p.values(a, b))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> {
            Symbol proper = p.symbol("proper");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(proper).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, true), (Object)new TableFunctionNode.PassThroughColumn(b, false)))).source((PlanNode)p.values(a, b))));
        }).doesNotFire();
    }

    @Test
    public void testNoSource() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(p.symbol("proper"))))).doesNotFire();
    }

    @Test
    public void testMultipleTableArguments() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(p.symbol("proper")).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, true))), new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(b, true))), new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, false)))).source((PlanNode)p.values(a, b, c, d))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"proper")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of())), PlanMatchPattern.values("a", "b", "c", "d"))));
    }
}

