/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneSpatialJoinColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneSpatialJoinColumns
extends BaseRuleTest {
    public TestPruneSpatialJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void notAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneSpatialJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol r = p.symbol("r");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), p.spatialJoin(SpatialJoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b, r), (List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)r), PlanBuilder.expression("ST_Distance(a, b) <= r")));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.spatialJoin("ST_Distance(a, b) <= r", Optional.empty(), Optional.of(ImmutableList.of((Object)"a")), PlanMatchPattern.values("a"), PlanMatchPattern.values("b", "r"))));
    }

    @Test
    public void allOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneSpatialJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol r = p.symbol("r");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b, r}), p.spatialJoin(SpatialJoinNode.Type.INNER, (PlanNode)p.values(a), (PlanNode)p.values(b, r), (List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)r), PlanBuilder.expression("ST_Distance(a, b) <= r")));
        }).doesNotFire();
    }
}

