/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergePatternRecognitionNodes;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestMergePatternRecognitionNodes
extends BaseRuleTest {
    public TestMergePatternRecognitionNodes() {
        super(new Plugin[0]);
    }

    @Test
    public void testSpecificationsDoNotMatch() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "false").source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a")}), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "false").source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        QualifiedName count = this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"count"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})).toQualifiedName();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)PlanBuilder.expression("a"))), PlanBuilder.expression("5"))).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)PlanBuilder.expression("b"))), PlanBuilder.expression("5"))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))).doesNotFire();
    }

    @Test
    public void testParentDependsOnSourceCreatedOutputs() {
        ResolvedFunction lag = MetadataManager.createTestMetadataManager().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"lag"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), "LAST(X.measure)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), "MATCH_NUMBER()", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), "LAST(X.function)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addWindowFunction(p.symbol("function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addWindowFunction(p.symbol("dependent"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("function").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addWindowFunction(p.symbol("function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addWindowFunction(p.symbol("dependent"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("measure").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), "MATCH_NUMBER()", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
    }

    @Test
    public void testParentDependsOnSourceCreatedOutputsWithProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), "LAST(X.measure)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("measure")}), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), "MATCH_NUMBER()", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), "LAST(X.renamed)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("renamed"), (Expression)PlanBuilder.expression("measure")), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), "MATCH_NUMBER()", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), "LAST(X.projected)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("projected"), (Expression)PlanBuilder.expression("a * measure")), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), "MATCH_NUMBER()", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }

    @Test
    public void testMergeWithoutProject() {
        ResolvedFunction lag = MetadataManager.createTestMetadataManager().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"lag"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("d")), (Map)ImmutableMap.of((Object)p.symbol("d"), (Object)SortOrder.ASC_NULLS_LAST))).addMeasure(p.symbol("parent_measure"), "LAST(X.b)", (Type)BigintType.BIGINT).addWindowFunction(p.symbol("parent_function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.LAST, new IrLabel("X")).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("d")), (Map)ImmutableMap.of((Object)p.symbol("d"), (Object)SortOrder.ASC_NULLS_LAST))).addMeasure(p.symbol("child_measure"), "FIRST(X.a)", (Type)BigintType.BIGINT).addWindowFunction(p.symbol("child_function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("b").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.LAST, new IrLabel("X")).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c"), p.symbol("d"))))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("parent_measure", "LAST(X.b)", (Type)BigintType.BIGINT).addMeasure("child_measure", "FIRST(X.a)", (Type)BigintType.BIGINT).addFunction("parent_function", PlanMatchPattern.functionCall("lag", (List<String>)ImmutableList.of((Object)"a"))).addFunction("child_function", PlanMatchPattern.functionCall("lag", (List<String>)ImmutableList.of((Object)"b"))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.LAST, new IrLabel("X")).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.values("a", "b", "c", "d")));
    }

    @Test
    public void testMergeWithoutProjectAndPruneOutputs() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).addMeasure(p.symbol("parent_measure"), "LAST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).addMeasure(p.symbol("child_measure"), "FIRST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c"))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression("c"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure")), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addMeasure("parent_measure", "LAST(X.b)", (Type)BigintType.BIGINT).addMeasure("child_measure", "FIRST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.values("a", "b", "c"))));
    }

    @Test
    public void testMergeWithProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("a"), (Symbol)p.symbol("expression"), (Expression)PlanBuilder.expression("a * b")), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure"), (Object)"expression", (Object)PlanMatchPattern.expression("expression")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure"), (Object)"child_measure", (Object)PlanMatchPattern.expression("child_measure"), (Object)"expression", (Object)PlanMatchPattern.expression("a * b")), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", "LAST(X.a)", (Type)BigintType.BIGINT).addMeasure("child_measure", "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.values("a", "b")))));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("a"), (Symbol)p.symbol("expression"), (Expression)PlanBuilder.expression("a * b * child_measure")), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure"), (Object)"expression", (Object)PlanMatchPattern.expression("expression")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure"), (Object)"child_measure", (Object)PlanMatchPattern.expression("child_measure"), (Object)"expression", (Object)PlanMatchPattern.expression("a * b * child_measure")), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", "LAST(X.a)", (Type)BigintType.BIGINT).addMeasure("child_measure", "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testMergeWithParentDependingOnProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), "LAST(X.expression_1)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.builder().put(p.symbol("a"), PlanBuilder.expression("a")).put(p.symbol("expression_1"), PlanBuilder.expression("a * b")).put(p.symbol("expression_2"), PlanBuilder.expression("a + b")).build(), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure"), (Object)"expression_1", (Object)PlanMatchPattern.expression("expression_1"), (Object)"expression_2", (Object)PlanMatchPattern.expression("expression_2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"a", (Object)PlanMatchPattern.expression("a")).put((Object)"b", (Object)PlanMatchPattern.expression("b")).put((Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure")).put((Object)"child_measure", (Object)PlanMatchPattern.expression("child_measure")).put((Object)"expression_1", (Object)PlanMatchPattern.expression("expression_1")).put((Object)"expression_2", (Object)PlanMatchPattern.expression("a + b")).buildOrThrow(), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", "LAST(X.expression_1)", (Type)BigintType.BIGINT).addMeasure("child_measure", "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"expression_1", (Object)PlanMatchPattern.expression("a * b")), PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testOneRowPerMatchMergeWithParentDependingOnProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).addMeasure(p.symbol("parent_measure"), "LAST(X.expression_1)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.project(Assignments.builder().put(p.symbol("a"), PlanBuilder.expression("a")).put(p.symbol("child_measure"), PlanBuilder.expression("child_measure")).put(p.symbol("expression_1"), PlanBuilder.expression("a * a")).put(p.symbol("expression_2"), PlanBuilder.expression("a + a")).build(), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).addMeasure(p.symbol("child_measure"), "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"parent_measure", (Object)PlanMatchPattern.expression("parent_measure"), (Object)"child_measure", (Object)PlanMatchPattern.expression("child_measure"), (Object)"expression_2", (Object)PlanMatchPattern.expression("a + a")), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addMeasure("parent_measure", "LAST(X.expression_1)", (Type)BigintType.BIGINT).addMeasure("child_measure", "FIRST(X.b)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"expression_1", (Object)PlanMatchPattern.expression("a * a")), PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testMergeWithAggregation() {
        QualifiedName count = this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"count"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})).toQualifiedName();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)PlanBuilder.expression("a"))), PlanBuilder.expression("5"))).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)PlanBuilder.expression("a"))), PlanBuilder.expression("5"))).source((PlanNode)p.values(p.symbol("a"))))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)PlanBuilder.expression("a"))), PlanBuilder.expression("5"))), PlanMatchPattern.values("a")));
    }
}

