/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.cost.TaskCountEstimator;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestTableScanNodePartitioning;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DetermineTableScanNodePartitioning;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDetermineTableScanNodePartitioning {
    private RuleTester tester;

    @BeforeAll
    public void setUp() {
        this.tester = RuleTester.builder().withDefaultCatalogConnectorFactory(TestTableScanNodePartitioning.createMockFactory()).build();
    }

    @AfterAll
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testEnablePlanWithTableNodePartitioning() {
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "partitioned_table", 10, true);
    }

    @Test
    public void testDisablePlanWithTableNodePartitioning() {
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "partitioned_table", 10, false);
    }

    @Test
    public void testTableScanWithoutConnectorPartitioning() {
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "unpartitioned_table", 10, false);
    }

    @Test
    public void testTableScanWithFixedConnectorPartitioning() {
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "fixed_partitioned_table", 10, true);
    }

    @Test
    public void testTableScanWithInsufficientBucketToTaskRatio() {
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "partitioned_table", 20, true);
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "partitioned_table", 21, false);
        this.testPlanWithTableNodePartitioning(TestTableScanNodePartitioning.ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, "single_bucket_table", 3, false);
    }

    private void testPlanWithTableNodePartitioning(Session session, String tableName, int numberOfTasks, boolean expectedEnabled) {
        TableHandle tableHandle = this.tester.getCurrentCatalogTableHandle("test_schema", tableName);
        this.tester.assertThat((Rule<?>)new DetermineTableScanNodePartitioning(this.tester.getMetadata(), this.tester.getQueryRunner().getNodePartitioningManager(), new TaskCountEstimator(() -> numberOfTasks))).on(p -> {
            Symbol a = p.symbol("column_a");
            Symbol b = p.symbol("column_b");
            return p.tableScan(tableHandle, (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)a, (Object)TestTableScanNodePartitioning.COLUMN_HANDLE_A, (Object)b, (Object)TestTableScanNodePartitioning.COLUMN_HANDLE_B));
        }).withSession(session).matches(PlanMatchPattern.tableScan(tableHandle.getConnectorHandle()::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"A", arg_0 -> ((ColumnHandle)TestTableScanNodePartitioning.COLUMN_HANDLE_A).equals(arg_0), (Object)"B", arg_0 -> ((ColumnHandle)TestTableScanNodePartitioning.COLUMN_HANDLE_B).equals(arg_0))).with(this.planWithTableNodePartitioning(expectedEnabled)));
    }

    private Matcher planWithTableNodePartitioning(final boolean enabled) {
        return new Matcher(){

            @Override
            public boolean shapeMatches(PlanNode node) {
                return node instanceof TableScanNode;
            }

            @Override
            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                TableScanNode tableScanNode = (TableScanNode)node;
                if (tableScanNode.getUseConnectorNodePartitioning().isEmpty()) {
                    return MatchResult.NO_MATCH;
                }
                if (tableScanNode.isUseConnectorNodePartitioning() != enabled) {
                    return MatchResult.NO_MATCH;
                }
                return MatchResult.match();
            }
        };
    }
}

