/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DecorrelateUnnest;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDecorrelateUnnest
extends BaseRuleTest {
    public TestDecorrelateUnnest() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireWithoutUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.limit(5L, (PlanNode)p.values(new Symbol[0])))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSourceDependentUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("a"), (List)ImmutableList.of((Object)p.symbol("unnested_a")))), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testLeftCorrelatedJoinWithLeftUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testInnerCorrelatedJoinWithLeftUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testInnerCorrelatedJoinWithInnerUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.INNER, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testLeftCorrelatedJoinWithInnerUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unnested_corr", (Object)PlanMatchPattern.expression("IF((ordinality IS NULL), CAST(null AS bigint), unnested_corr)")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testEnforceSingleRow() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unnested_corr", (Object)PlanMatchPattern.expression("IF((ordinality IS NULL), CAST(null AS bigint), unnested_corr)")), PlanMatchPattern.filter("IF((row_number > BIGINT '1'), CAST(\"@fail@52QIVV94JMEG607IGOBHL05P1613CN1P9T92HEMH7BITOAOHO6M5DJCDG6AVS0EF51Q4I3398DN9SEQVJ68ED8D9AA82LGAE01OA96R7FI8O05GF5V71FKQKBAP7GSQ55HDD19GI0FESCSJFDP48HV1S2NABNSUSOP897D7E08301TKKLOLOGECE3MO5MF6NVBB4I1GJJ9N18===\"(INTEGER '28', VARCHAR 'Scalar sub-query has returned multiple rows') AS boolean), true)", PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of((Object)"unique")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testLimit() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.limit(5L, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("row_number <= BIGINT '5'", PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of((Object)"unique")).maxRowCountPerPartition(Optional.empty()), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testLimitWithTies() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.limit(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("rank_number <= BIGINT '5'", PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("rank_number", PlanMatchPattern.functionCall("rank", (List<String>)ImmutableList.of())), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testTopN() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.topN(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("row_number <= BIGINT '5'", PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testProject() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)PlanBuilder.expression("unnested_corr IS NULL")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unique", (Object)PlanMatchPattern.expression("unique"), (Object)"ordinality", (Object)PlanMatchPattern.expression("ordinality"), (Object)"boolean_result", (Object)PlanMatchPattern.expression("unnested_corr IS NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)PlanBuilder.expression("unnested_corr IS NULL")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"boolean_result", (Object)PlanMatchPattern.expression("IF((ordinality IS NULL), CAST(null AS bigint), boolean_result)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unique", (Object)PlanMatchPattern.expression("unique"), (Object)"ordinality", (Object)PlanMatchPattern.expression("ordinality"), (Object)"boolean_result", (Object)PlanMatchPattern.expression("unnested_corr IS NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }

    @Test
    public void testDifferentNodesInSubquery() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("integer_result"), (Expression)PlanBuilder.expression("IF(boolean_result, 1, -1)")), (PlanNode)p.limit(5L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)PlanBuilder.expression("unnested_corr IS NULL")), (PlanNode)p.topN(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("IF((row_number > BIGINT '1'), CAST(\"@fail@52QIVV94JMEG607IGOBHL05P1613CN1P9T92HEMH7BITOAOHO6M5DJCDG6AVS0EF51Q4I3398DN9SEQVJ68ED8D9AA82LGAE01OA96R7FI8O05GF5V71FKQKBAP7GSQ55HDD19GI0FESCSJFDP48HV1S2NABNSUSOP897D7E08301TKKLOLOGECE3MO5MF6NVBB4I1GJJ9N18===\"(INTEGER '28', VARCHAR 'Scalar sub-query has returned multiple rows') AS boolean), true)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unique", (Object)PlanMatchPattern.expression("unique"), (Object)"ordinality", (Object)PlanMatchPattern.expression("ordinality"), (Object)"row_number", (Object)PlanMatchPattern.expression("row_number"), (Object)"integer_result", (Object)PlanMatchPattern.expression("IF(boolean_result, 1, -1)")), PlanMatchPattern.filter("row_number <= BIGINT '5'", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unique", (Object)PlanMatchPattern.expression("unique"), (Object)"ordinality", (Object)PlanMatchPattern.expression("ordinality"), (Object)"row_number", (Object)PlanMatchPattern.expression("row_number"), (Object)"boolean_result", (Object)PlanMatchPattern.expression("unnested_corr IS NULL")), PlanMatchPattern.filter("row_number <= BIGINT '10'", PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))))))));
    }

    @Test
    public void testWithPreexistingOrdinality() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.of(p.symbol("ordinality")), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unnested_corr", (Object)PlanMatchPattern.expression("IF((ordinality IS NULL), CAST(null AS bigint), unnested_corr)")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testPreprojectUnnestSymbol() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("char_array"), (List)ImmutableList.of((Object)p.symbol("unnested_char")))), Optional.empty(), JoinNode.Type.LEFT, Optional.empty(), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("char_array"), (Expression)PlanBuilder.expression("regexp_extract_all(corr, '.')")), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique", (Object)"char_array"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("char_array", (List<String>)ImmutableList.of((Object)"unnested_char"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"char_array", (Object)PlanMatchPattern.expression("regexp_extract_all(corr, '.')")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }
}

