/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkReorderInterconnectedJoins {
    @Benchmark
    public MaterializedResult benchmarkReorderJoins(BenchmarkInfo benchmarkInfo) {
        return benchmarkInfo.getQueryRunner().execute(benchmarkInfo.getQuery());
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkReorderInterconnectedJoins.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkInfo {
        @Param(value={"ELIMINATE_CROSS_JOINS", "AUTOMATIC"})
        private String joinReorderingStrategy;
        @Param(value={"2", "4", "6", "8", "10"})
        private int numberOfTables;
        private String query;
        private LocalQueryRunner queryRunner;

        @Setup
        public void setup() {
            Preconditions.checkState((this.numberOfTables >= 2 ? 1 : 0) != 0, (Object)"numberOfTables must be >= 2");
            Session session = TestingSession.testSessionBuilder().setSystemProperty("join_reordering_strategy", this.joinReorderingStrategy).setSystemProperty("join_distribution_type", "AUTOMATIC").setCatalog("tpch").setSchema("tiny").build();
            this.queryRunner = LocalQueryRunner.create((Session)session);
            this.queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("EXPLAIN SELECT * FROM nation n1");
            for (int i = 2; i <= this.numberOfTables; ++i) {
                stringBuilder.append(String.format(" JOIN nation n%s ON n%s.nationkey = n%s.nationkey", i, i - 1, i));
            }
            this.query = stringBuilder.toString();
        }

        public String getQuery() {
            return this.query;
        }

        public QueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
        }
    }
}

