/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.sql.ExpressionUtils;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SymbolReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionVerifier {
    private final SqlParser parser = new SqlParser();

    @Test
    public void test() {
        Expression actual = this.expression("NOT(orderkey = 3 AND custkey = 3 AND orderkey < 10)");
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)actual, this.expression("NOT(X = 3 AND Y = 3 AND X < 10)"))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> verifier.process((Node)actual, this.expression("NOT(X = 3 AND Y = 3 AND Z < 10)"))).isInstanceOf(IllegalStateException.class)).hasMessage("missing expression for alias Z");
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)actual, this.expression("NOT(X = 3 AND X = 3 AND X < 10)"))));
    }

    @Test
    public void testCast() {
        SymbolAliases aliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(aliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("VARCHAR '2'"), this.expression("VARCHAR '2'"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("VARCHAR '2'"), this.expression("CAST('2' AS bigint)"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("CAST(orderkey AS varchar)"), this.expression("CAST(X AS varchar)"))));
    }

    @Test
    public void testBetween() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("Y BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("custkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 2 AND 4"), this.expression("X BETWEEN 1 AND 2"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN '1' AND '2'"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("orderkey BETWEEN 1 AND 2"), this.expression("X BETWEEN 4 AND 7"))));
    }

    @Test
    public void testSymmetry() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("a", new SymbolReference("x")).put("b", new SymbolReference("y")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x > y"), this.expression("a > b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x > y"), this.expression("b < a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y < x"), this.expression("a > b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y < x"), this.expression("b < a"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("x < y"), this.expression("a > b"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("x < y"), this.expression("b < a"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("y > x"), this.expression("a > b"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("y > x"), this.expression("b < a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x >= y"), this.expression("a >= b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x >= y"), this.expression("b <= a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y <= x"), this.expression("a >= b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y <= x"), this.expression("b <= a"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("x <= y"), this.expression("a >= b"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("x <= y"), this.expression("b <= a"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("y >= x"), this.expression("a >= b"))));
        Assert.assertFalse((boolean)((Boolean)verifier.process((Node)this.expression("y >= x"), this.expression("b <= a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x = y"), this.expression("a = b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x = y"), this.expression("b = a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y = x"), this.expression("a = b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y = x"), this.expression("b = a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x <> y"), this.expression("a <> b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x <> y"), this.expression("b <> a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y <> x"), this.expression("a <> b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y <> x"), this.expression("b <> a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x IS DISTINCT FROM y"), this.expression("a IS DISTINCT FROM b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("x IS DISTINCT FROM y"), this.expression("b IS DISTINCT FROM a"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y IS DISTINCT FROM x"), this.expression("a IS DISTINCT FROM b"))));
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)this.expression("y IS DISTINCT FROM x"), this.expression("b IS DISTINCT FROM a"))));
    }

    private Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)this.parser.createExpression(sql, new ParsingOptions()));
    }
}

