/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowNumberNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowNumberMatcher
implements Matcher {
    private final Optional<List<SymbolAlias>> partitionBy;
    private final Optional<Optional<Integer>> maxRowCountPerPartition;
    private final Optional<SymbolAlias> rowNumberSymbol;
    private final Optional<Optional<SymbolAlias>> hashSymbol;
    private final Optional<Boolean> orderSensitive;

    private RowNumberMatcher(Optional<List<SymbolAlias>> partitionBy, Optional<Optional<Integer>> maxRowCountPerPartition, Optional<SymbolAlias> rowNumberSymbol, Optional<Optional<SymbolAlias>> hashSymbol, Optional<Boolean> orderSensitive) {
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.maxRowCountPerPartition = Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null");
        this.rowNumberSymbol = Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        this.orderSensitive = Objects.requireNonNull(orderSensitive, "orderSensitive is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof RowNumberNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Object expected;
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        RowNumberNode rowNumberNode = (RowNumberNode)node;
        if (this.partitionBy.isPresent() && !(expected = (List)this.partitionBy.get().stream().map(alias -> alias.toSymbol(symbolAliases)).collect(ImmutableList.toImmutableList())).equals(rowNumberNode.getPartitionBy())) {
            return MatchResult.NO_MATCH;
        }
        if (this.rowNumberSymbol.isPresent() && !(expected = this.rowNumberSymbol.get().toSymbol(symbolAliases)).equals((Object)rowNumberNode.getRowNumberSymbol())) {
            return MatchResult.NO_MATCH;
        }
        if (this.maxRowCountPerPartition.isPresent() && !this.maxRowCountPerPartition.get().equals(rowNumberNode.getMaxRowCountPerPartition())) {
            return MatchResult.NO_MATCH;
        }
        if (this.hashSymbol.isPresent() && !((Optional)(expected = this.hashSymbol.get().map(alias -> alias.toSymbol(symbolAliases)))).equals(rowNumberNode.getHashSymbol())) {
            return MatchResult.NO_MATCH;
        }
        if (this.orderSensitive.isPresent() && !this.orderSensitive.get().equals(rowNumberNode.isOrderSensitive())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("maxRowCountPerPartition", this.maxRowCountPerPartition).add("rowNumberSymbol", this.rowNumberSymbol).add("hashSymbol", this.hashSymbol).add("orderSensitive", this.orderSensitive).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<List<SymbolAlias>> partitionBy = Optional.empty();
        private Optional<Optional<Integer>> maxRowCountPerPartition = Optional.empty();
        private Optional<SymbolAlias> rowNumberSymbol = Optional.empty();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();
        private Optional<Boolean> orderSensitive = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder partitionBy(List<String> partitionBy) {
            Objects.requireNonNull(partitionBy, "partitionBy is null");
            this.partitionBy = Optional.of((List)partitionBy.stream().map(SymbolAlias::new).collect(ImmutableList.toImmutableList()));
            return this;
        }

        public Builder maxRowCountPerPartition(Optional<Integer> maxRowCountPerPartition) {
            this.maxRowCountPerPartition = Optional.of(Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null"));
            return this;
        }

        public Builder rowNumberSymbol(SymbolAlias rowNumberSymbol) {
            this.rowNumberSymbol = Optional.of(Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null"));
            return this;
        }

        public Builder hashSymbol(Optional<String> hashSymbol) {
            Objects.requireNonNull(hashSymbol, "hashSymbol is null");
            this.hashSymbol = Optional.of(hashSymbol.map(SymbolAlias::new));
            return this;
        }

        public Builder orderSensitive(boolean isOrderSensitive) {
            this.orderSensitive = Optional.of(isOrderSensitive);
            return this;
        }

        PlanMatchPattern build() {
            return PlanMatchPattern.node(RowNumberNode.class, this.source).with(new RowNumberMatcher(this.partitionBy, this.maxRowCountPerPartition, this.rowNumberSymbol, this.hashSymbol, this.orderSensitive));
        }
    }
}

