/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.Util;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class ExchangeMatcher
implements Matcher {
    private final ExchangeNode.Scope scope;
    private final Optional<ExchangeNode.Type> type;
    private final Optional<PartitioningHandle> partitioningHandle;
    private final List<PlanMatchPattern.Ordering> orderBy;
    private final Set<String> partitionedBy;
    private final Optional<List<List<String>>> inputs;
    private final Optional<Optional<Integer>> partitionCount;

    public ExchangeMatcher(ExchangeNode.Scope scope, Optional<ExchangeNode.Type> type, Optional<PartitioningHandle> partitioningHandle, List<PlanMatchPattern.Ordering> orderBy, Set<String> partitionedBy, Optional<List<List<String>>> inputs, Optional<Optional<Integer>> partitionCount) {
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.partitionedBy = Objects.requireNonNull(partitionedBy, "partitionedBy is null");
        this.inputs = Objects.requireNonNull(inputs, "inputs is null");
        this.partitionCount = Objects.requireNonNull(partitionCount, "partitionCount is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == this.scope && this.type.map(requiredType -> requiredType == exchangeNode.getType()).orElse(true) != false && this.partitioningHandle.map(handle -> handle.equals((Object)exchangeNode.getPartitioningScheme().getPartitioning().getHandle())).orElse(true) != false;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        ExchangeNode exchangeNode = (ExchangeNode)node;
        if (!this.orderBy.isEmpty()) {
            if (exchangeNode.getOrderingScheme().isEmpty()) {
                return MatchResult.NO_MATCH;
            }
            if (!Util.orderingSchemeMatches(this.orderBy, (OrderingScheme)exchangeNode.getOrderingScheme().get(), symbolAliases)) {
                return MatchResult.NO_MATCH;
            }
        }
        if (!this.partitionedBy.isEmpty()) {
            Set partitionedColumns = exchangeNode.getPartitioningScheme().getPartitioning().getColumns();
            if (!this.partitionedBy.stream().map(symbolAliases::get).map(Symbol::from).allMatch(partitionedColumns::contains)) {
                return MatchResult.NO_MATCH;
            }
        }
        if (this.inputs.isPresent()) {
            if (this.inputs.get().size() != exchangeNode.getInputs().size()) {
                return MatchResult.NO_MATCH;
            }
            for (int i = 0; i < exchangeNode.getInputs().size(); ++i) {
                if (((ImmutableList)this.inputs.get().get(i).stream().map(symbolAliases::get).map(Symbol::from).collect(ImmutableList.toImmutableList())).equals(exchangeNode.getInputs().get(i))) continue;
                return MatchResult.NO_MATCH;
            }
        }
        if (this.partitionCount.isPresent() && !this.partitionCount.get().equals(exchangeNode.getPartitioningScheme().getPartitionCount())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        MoreObjects.ToStringHelper string = MoreObjects.toStringHelper((Object)this).add("scope", (Object)this.scope).add("type", this.type).add("partitionHandle", this.partitioningHandle).add("orderBy", this.orderBy).add("partitionedBy", this.partitionedBy);
        this.inputs.ifPresent(inputs -> string.add("inputs", inputs));
        this.partitionCount.ifPresent(partitionCount -> string.add("partitionCount", partitionCount));
        return string.toString();
    }
}

