/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DistinctLimitMatcher
implements Matcher {
    private final long limit;
    private final List<PlanTestSymbol> distinctSymbols;
    private final Optional<PlanTestSymbol> hashSymbol;

    public DistinctLimitMatcher(long limit, List<PlanTestSymbol> distinctSymbols, Optional<PlanTestSymbol> hashSymbol) {
        this.limit = limit;
        this.distinctSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(distinctSymbols, "distinctSymbols is null"));
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof DistinctLimitNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        DistinctLimitNode distinctLimitNode = (DistinctLimitNode)node;
        if (distinctLimitNode.getLimit() != this.limit) {
            return MatchResult.NO_MATCH;
        }
        if (!distinctLimitNode.getHashSymbol().equals(this.hashSymbol.map(alias -> alias.toSymbol(symbolAliases)))) {
            return MatchResult.NO_MATCH;
        }
        return new MatchResult(ImmutableSet.copyOf((Collection)distinctLimitNode.getDistinctSymbols()).equals(this.distinctSymbols.stream().map(alias -> alias.toSymbol(symbolAliases)).collect(ImmutableSet.toImmutableSet())));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("limit", this.limit).add("distinctSymbols", this.distinctSymbols).add("hashSymbol", this.hashSymbol).toString();
    }
}

