/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import java.util.Collection;
import java.util.Objects;

final class CorrelatedJoinMatcher
implements Matcher {
    private final Expression filter;

    CorrelatedJoinMatcher(Expression filter) {
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof CorrelatedJoinNode)) {
            throw new IllegalStateException("This is a detailed matcher for CorrelatedJoinNode, got: " + node);
        }
        CorrelatedJoinNode correlatedJoinNode = (CorrelatedJoinNode)node;
        Expression filter = correlatedJoinNode.getFilter();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        DynamicFilters.ExtractResult extractResult = DynamicFilters.extractDynamicFilters((Expression)filter);
        return new MatchResult((Boolean)verifier.process((Node)ExpressionUtils.combineConjuncts((Metadata)metadata, (Collection)extractResult.getStaticConjuncts()), filter));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).toString();
    }
}

