/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.Util;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConnectorAwareTableScanMatcher
implements Matcher {
    private final Predicate<ConnectorTableHandle> expectedTable;
    private final TupleDomain<Predicate<ColumnHandle>> expectedEnforcedConstraint;
    private final Predicate<Optional<PlanNodeStatsEstimate>> expectedStatistics;

    public ConnectorAwareTableScanMatcher(Predicate<ConnectorTableHandle> expectedTable, TupleDomain<Predicate<ColumnHandle>> expectedEnforcedConstraint, Predicate<Optional<PlanNodeStatsEstimate>> expectedStatistics) {
        this.expectedTable = Objects.requireNonNull(expectedTable, "expectedTable is null");
        this.expectedEnforcedConstraint = Objects.requireNonNull(expectedEnforcedConstraint, "expectedEnforcedConstraint is null");
        this.expectedStatistics = Objects.requireNonNull(expectedStatistics, "expectedStatistics is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableScanNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableScanNode tableScanNode = (TableScanNode)node;
        TupleDomain actual = tableScanNode.getEnforcedConstraint();
        boolean tableMatches = this.expectedTable.test(tableScanNode.getTable().getConnectorHandle());
        boolean domainsMatch = Util.domainsMatch(this.expectedEnforcedConstraint, (TupleDomain<ColumnHandle>)actual);
        boolean statisticMatch = this.expectedStatistics.test(tableScanNode.getStatistics());
        return new MatchResult(tableMatches && domainsMatch && statisticMatch);
    }

    public static PlanMatchPattern create(Predicate<ConnectorTableHandle> table, TupleDomain<Predicate<ColumnHandle>> constraints, Predicate<Optional<PlanNodeStatsEstimate>> expectedStatistics) {
        return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new ConnectorAwareTableScanMatcher(table, constraints, expectedStatistics));
    }
}

