/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchPartitioningHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestInsert
extends BasePlanTest {
    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("mock").setSchema("schema");
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        queryRunner.createCatalog("mock", (ConnectorFactory)MockConnectorFactory.builder().withGetTableHandle((session, schemaTableName) -> {
            if (schemaTableName.getTableName().equals("test_table_preferred_partitioning")) {
                return new MockConnectorTableHandle((SchemaTableName)schemaTableName);
            }
            if (schemaTableName.getTableName().equals("test_table_required_partitioning")) {
                return new MockConnectorTableHandle((SchemaTableName)schemaTableName);
            }
            return null;
        }).withGetColumns(name -> ImmutableList.of((Object)new ColumnMetadata("column1", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("column2", (Type)IntegerType.INTEGER))).withGetInsertLayout((session, tableName) -> {
            if (tableName.getTableName().equals("test_table_preferred_partitioning")) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"column1")));
            }
            if (tableName.getTableName().equals("test_table_required_partitioning")) {
                return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)new TpchPartitioningHandle("orders", 10L), (List)ImmutableList.of((Object)"column1")));
            }
            return Optional.empty();
        }).withGetNewTableLayout((session, tableMetadata) -> {
            if (tableMetadata.getTable().getTableName().equals("new_test_table_preferred_partitioning")) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"column1")));
            }
            if (tableMetadata.getTable().getTableName().equals("new_test_table_required_partitioning")) {
                return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)new TpchPartitioningHandle("orders", 10L), (List)ImmutableList.of((Object)"column1")));
            }
            if (tableMetadata.getTable().getTableName().equals("new_test_table_unpartitioned")) {
                return Optional.empty();
            }
            return Optional.empty();
        }).build(), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testInsertWithPreferredPartitioning() {
        this.assertDistributedPlan("INSERT into test_table_preferred_partitioning VALUES (1, 2)", this.withForcedPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.anyTree(PlanMatchPattern.values("column1", "column2"))))))));
    }

    @Test
    public void testInsertWithoutPreferredPartitioningEnabled() {
        this.assertDistributedPlan("INSERT into test_table_preferred_partitioning VALUES (1, 2)", this.withoutPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column1", "column2")))));
    }

    @Test
    public void testInsertWithRequiredPartitioning() {
        this.testInsertWithRequiredPartitioning(this.withForcedPreferredPartitioning());
        this.testInsertWithRequiredPartitioning(this.withoutPreferredPartitioning());
    }

    private void testInsertWithRequiredPartitioning(Session session) {
        this.assertDistributedPlan("INSERT into test_table_required_partitioning VALUES (1, 2)", session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.values("column1", "column2")).with(this.exchangeWithoutSystemPartitioning())).with(this.exchangeWithoutSystemPartitioning()))));
    }

    @Test
    public void testCreateTableAsSelectWithPreferredPartitioning() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_preferred_partitioning (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withForcedPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.anyTree(PlanMatchPattern.values("column1", "column2"))))))));
    }

    @Test
    public void testCreateTableAsSelectWithPreferredPartitioningAndNoPartitioningColumns() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_preferred_partitioning (column2) AS SELECT * FROM (VALUES 2) t(column2)", this.withForcedPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column2")))));
    }

    @Test
    public void testCreateTableAsSelectWithoutPreferredPartitioningEnabled() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_preferred_partitioning (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withoutPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column1", "column2")))));
    }

    @Test
    public void testCreateTableAsSelectWithRequiredPartitioning() {
        this.testCreateTableAsSelectWithRequiredPartitioning(this.withForcedPreferredPartitioning());
        this.testCreateTableAsSelectWithRequiredPartitioning(this.withoutPreferredPartitioning());
    }

    private void testCreateTableAsSelectWithRequiredPartitioning(Session session) {
        this.assertDistributedPlan("CREATE TABLE new_test_table_required_partitioning (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.values("column1", "column2")).with(this.exchangeWithoutSystemPartitioning())).with(this.exchangeWithoutSystemPartitioning()))));
    }

    @Test
    public void testCreateTableAsSelectUnpartitioned() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_unpartitioned (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withForcedPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column1", "column2")))));
    }

    private Matcher exchangeWithoutSystemPartitioning() {
        return new Matcher(){

            @Override
            public boolean shapeMatches(PlanNode node) {
                return node instanceof ExchangeNode;
            }

            @Override
            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                return new MatchResult(!(((ExchangeNode)node).getPartitioningScheme().getPartitioning().getHandle().getConnectorHandle() instanceof SystemPartitioningHandle));
            }
        };
    }

    private Session withForcedPreferredPartitioning() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("scale_writers", "false").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("task_partitioned_writer_count", "16").setSystemProperty("task_writer_count", "16").build();
    }

    private Session withoutPreferredPartitioning() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_preferred_write_partitioning", "false").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("task_writer_count", "16").setSystemProperty("task_partitioned_writer_count", "2").build();
    }
}

