/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Joiner;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.VarArgsToArrayAdapterGenerator;
import io.trino.sql.query.QueryAssertions;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestVarArgsToArrayAdapterGenerator {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{TestVarArgsSum.VAR_ARGS_SUM}));
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testArrayElements() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("var_args_sum", new String[0])))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("var_args_sum", "1")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("var_args_sum", "1", "2")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("var_args_sum", "null")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("var_args_sum", "1", "null", "2", "null", "3")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("var_args_sum", "1", "2", "3")))).isEqualTo(6);
        int k = 100;
        String expression = String.format("var_args_sum(%s)", Joiner.on((String)",").join((Iterable)IntStream.rangeClosed(1, k).boxed().collect(Collectors.toSet())));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(expression)))).isEqualTo((1 + k) * k / 2);
    }

    public static class TestVarArgsSum
    extends SqlScalarFunction {
        public static final TestVarArgsSum VAR_ARGS_SUM = new TestVarArgsSum();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(TestVarArgsSum.class, (String)"varArgsSum", (Class[])new Class[]{Object.class, long[].class});
        private static final MethodHandle USER_STATE_FACTORY = Reflection.methodHandle(TestVarArgsSum.class, (String)"createState", (Class[])new Class[0]);

        private TestVarArgsSum() {
            super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("var_args_sum").returnType((Type)IntegerType.INTEGER).argumentType((Type)IntegerType.INTEGER).variableArity().build()).nondeterministic().description("return sum of all the parameters").build());
        }

        protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
            VarArgsToArrayAdapterGenerator.MethodHandleAndConstructor methodHandleAndConstructor = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Long.TYPE, Long.TYPE, (int)boundSignature.getArity(), (MethodHandle)METHOD_HANDLE, (MethodHandle)USER_STATE_FACTORY);
            return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandleAndConstructor.getMethodHandle(), Optional.of(methodHandleAndConstructor.getConstructor()));
        }

        @UsedByGeneratedCode
        public static Object createState() {
            return null;
        }

        @UsedByGeneratedCode
        public static long varArgsSum(Object state, long[] values) {
            long sum = 0L;
            for (long value : values) {
                sum += value;
            }
            return sum;
        }
    }
}

