/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Key;
import com.google.inject.Module;
import com.nimbusds.oauth2.sdk.GrantType;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.log.Level;
import io.airlift.log.Logging;
import io.airlift.node.NodeInfo;
import io.trino.client.OkHttpUtil;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.TokenEndpointAuthMethod;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.server.ui.OAuth2WebUiAuthenticationFilter;
import io.trino.server.ui.WebUiModule;
import io.trino.testing.ResourcePresence;
import io.trino.util.AutoCloseableCloser;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class TestingHydraIdentityProvider
implements AutoCloseable {
    private static final String HYDRA_IMAGE = "oryd/hydra:v1.10.6";
    private static final String ISSUER = "https://localhost:4444/";
    private static final String DSN = "postgres://hydra:mysecretpassword@database:5432/hydra?sslmode=disable";
    private final Network network = Network.newNetwork();
    private final PostgreSQLContainer<?> databaseContainer = ((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer().withNetwork(this.network)).withNetworkAliases(new String[]{"database"})).withUsername("hydra").withPassword("mysecretpassword").withDatabaseName("hydra");
    private final GenericContainer<?> migrationContainer = ((FixedHostPortGenericContainer)this.createHydraContainer().withCommand(new String[]{"migrate", "sql", "--yes", "postgres://hydra:mysecretpassword@database:5432/hydra?sslmode=disable"})).withStartupCheckStrategy(new OneShotStartupCheckStrategy().withTimeout(Duration.ofMinutes(5L)));
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Duration ttlAccessToken;
    private final boolean useJwt;
    private final boolean exposeFixedPorts;
    private final OkHttpClient httpClient;
    private FixedHostPortGenericContainer<?> hydraContainer;

    public TestingHydraIdentityProvider() {
        this(Duration.ofMinutes(30L), true, false);
    }

    public TestingHydraIdentityProvider(Duration ttlAccessToken, boolean useJwt, boolean exposeFixedPorts) {
        this.ttlAccessToken = Objects.requireNonNull(ttlAccessToken, "ttlAccessToken is null");
        this.useJwt = useJwt;
        this.exposeFixedPorts = exposeFixedPorts;
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)httpClientBuilder);
        httpClientBuilder.followRedirects(false);
        this.httpClient = httpClientBuilder.build();
        this.closer.register((AutoCloseable)this.network);
        this.closer.register(this.databaseContainer);
        this.closer.register(this.migrationContainer);
    }

    public void start() throws Exception {
        this.databaseContainer.start();
        this.migrationContainer.start();
        TestingHttpServer loginAndConsentServer = this.createTestingLoginAndConsentServer();
        this.closer.register(() -> ((TestingHttpServer)loginAndConsentServer).stop());
        loginAndConsentServer.start();
        URI loginAndConsentBaseUrl = loginAndConsentServer.getBaseUrl();
        this.hydraContainer = (FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)this.createHydraContainer().withNetworkAliases(new String[]{"hydra"})).withExposedPorts(new Integer[]{4444, 4445})).withEnv("DSN", DSN)).withEnv("URLS_SELF_ISSUER", ISSUER)).withEnv("URLS_CONSENT", loginAndConsentBaseUrl + "/consent")).withEnv("URLS_LOGIN", loginAndConsentBaseUrl + "/login")).withEnv("SERVE_TLS_KEY_PATH", "/tmp/certs/localhost.pem")).withEnv("SERVE_TLS_CERT_PATH", "/tmp/certs/localhost.pem")).withEnv("TTL_ACCESS_TOKEN", this.ttlAccessToken.getSeconds() + "s")).withEnv("STRATEGIES_ACCESS_TOKEN", this.useJwt ? "jwt" : null)).withEnv("LOG_LEAK_SENSITIVE_VALUES", "true")).withCommand(new String[]{"serve", "all"})).withCopyFileToContainer(MountableFile.forClasspathResource((String)"/cert"), "/tmp/certs")).waitingFor((WaitStrategy)new WaitAllStrategy().withStrategy((WaitStrategy)Wait.forLogMessage((String)".*Setting up http server on :4444.*", (int)1)).withStrategy((WaitStrategy)Wait.forLogMessage((String)".*Setting up http server on :4445.*", (int)1)));
        if (this.exposeFixedPorts) {
            this.hydraContainer = this.hydraContainer.withFixedExposedPort(4444, 4444).withFixedExposedPort(4445, 4445);
        }
        this.closer.register(this.hydraContainer);
        this.hydraContainer.start();
    }

    public FixedHostPortGenericContainer<?> createHydraContainer() {
        return (FixedHostPortGenericContainer)new FixedHostPortGenericContainer(HYDRA_IMAGE).withNetwork(this.network);
    }

    public void createClient(String clientId, String clientSecret, TokenEndpointAuthMethod tokenEndpointAuthMethod, List<String> audiences, String callbackUrl) {
        ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)this.createHydraContainer().withCommand(new String[]{"clients", "create", "--endpoint", "https://hydra:4445", "--skip-tls-verify", "--id", clientId, "--secret", clientSecret, "--audience", String.join((CharSequence)",", audiences), "--grant-types", "authorization_code,refresh_token,client_credentials", "--response-types", "token,code,id_token", "--scope", "openid,offline", "--token-endpoint-auth-method", tokenEndpointAuthMethod.getValue(), "--callbacks", callbackUrl})).withStartupCheckStrategy(new OneShotStartupCheckStrategy().withTimeout(Duration.ofSeconds(30L)))).start();
    }

    public String getToken(String clientId, String clientSecret, List<String> audiences) throws IOException {
        try (Response response = this.httpClient.newCall(new Request.Builder().url("https://localhost:" + this.getAuthPort() + "/oauth2/token").addHeader("Authorization", Credentials.basic((String)clientId, (String)clientSecret)).post((RequestBody)new FormBody.Builder().add("grant_type", GrantType.CLIENT_CREDENTIALS.getValue()).add("audience", String.join((CharSequence)" ", audiences)).build()).build()).execute();){
            Preconditions.checkState((response.code() == 200 ? 1 : 0) != 0);
            Objects.requireNonNull(response.body());
            String string = this.mapper.readTree(response.body().byteStream()).get("access_token").textValue();
            return string;
        }
    }

    public int getAuthPort() {
        return this.hydraContainer.getMappedPort(4444);
    }

    public int getAdminPort() {
        return this.hydraContainer.getMappedPort(4445);
    }

    @Override
    public void close() throws Exception {
        this.closer.close();
    }

    private TestingHttpServer createTestingLoginAndConsentServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)new AcceptAllLoginsAndConsentsServlet(), (Map)ImmutableMap.of());
    }

    private static void runTestServer(boolean useJwt) throws Exception {
        try (TestingHydraIdentityProvider service = new TestingHydraIdentityProvider(Duration.ofMinutes(30L), useJwt, true);){
            service.start();
            service.createClient("trino-client", "trino-secret", TokenEndpointAuthMethod.CLIENT_SECRET_BASIC, (List<String>)ImmutableList.of((Object)"https://localhost:8443/ui"), "https://localhost:8443/oauth2/callback");
            ImmutableMap.Builder config = ImmutableMap.builder().put((Object)"web-ui.enabled", (Object)"true").put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.https.port", (Object)"8443").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.authentication.type", (Object)"oauth2").put((Object)"http-server.authentication.oauth2.issuer", (Object)ISSUER).put((Object)"http-server.authentication.oauth2.client-id", (Object)"trino-client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"trino-secret").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@.*").put((Object)"http-server.authentication.oauth2.oidc.use-userinfo-endpoint", (Object)String.valueOf(!useJwt)).put((Object)"oauth2-jwk.http-client.trust-store-path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath());
            try (TestingTrinoServer server = TestingTrinoServer.builder().setCoordinator(true).setAdditionalModule((Module)new WebUiModule()).setProperties((Map)config.buildOrThrow()).build();){
                ((OAuth2Client)server.getInstance(Key.get(OAuth2Client.class))).load();
                Thread.sleep(Long.MAX_VALUE);
            }
        }
    }

    @ResourcePresence
    public boolean isRunning() {
        return this.hydraContainer.getContainerId() != null || this.databaseContainer.getContainerId() != null || this.migrationContainer.getContainerId() != null;
    }

    public static void main(String[] args) throws Exception {
        Logging logging = Logging.initialize();
        try {
            logging.setLevel(OAuth2WebUiAuthenticationFilter.class.getName(), Level.DEBUG);
            logging.setLevel(OAuth2Service.class.getName(), Level.DEBUG);
            TestingHydraIdentityProvider.runTestServer(false);
        }
        finally {
            logging.clearLevel(OAuth2WebUiAuthenticationFilter.class.getName());
            logging.clearLevel(OAuth2Service.class.getName());
        }
    }

    private class AcceptAllLoginsAndConsentsServlet
    extends HttpServlet {
        private final ObjectMapper mapper = new ObjectMapper();
        private final OkHttpClient httpClient;

        public AcceptAllLoginsAndConsentsServlet() {
            OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
            OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)httpClientBuilder);
            this.httpClient = httpClientBuilder.build();
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (request.getPathInfo().equals("/login")) {
                this.acceptLogin(request, response);
                return;
            }
            if (request.getPathInfo().contains("/consent")) {
                this.acceptConsent(request, response);
                return;
            }
            response.setStatus(404);
        }

        private void acceptLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String loginChallenge = request.getParameter("login_challenge");
            try (Response loginAcceptResponse = this.acceptLogin(loginChallenge);){
                this.sendRedirect(loginAcceptResponse, response);
            }
        }

        private void acceptConsent(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String consentChallenge = request.getParameter("consent_challenge");
            JsonNode consentRequest = this.getConsentRequest(consentChallenge);
            try (Response acceptConsentResponse = this.acceptConsent(consentChallenge, consentRequest);){
                this.sendRedirect(acceptConsentResponse, response);
            }
        }

        private Response acceptLogin(String loginChallenge) throws IOException {
            return this.httpClient.newCall(new Request.Builder().url("https://localhost:" + TestingHydraIdentityProvider.this.getAdminPort() + "/oauth2/auth/requests/login/accept?login_challenge=" + loginChallenge).put(RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)this.mapper.writeValueAsString((Object)this.mapper.createObjectNode().put("subject", "foo@bar.com")))).build()).execute();
        }

        private JsonNode getConsentRequest(String consentChallenge) throws IOException {
            try (Response response = this.httpClient.newCall(new Request.Builder().url("https://localhost:" + TestingHydraIdentityProvider.this.getAdminPort() + "/oauth2/auth/requests/consent?consent_challenge=" + consentChallenge).get().build()).execute();){
                Objects.requireNonNull(response.body());
                JsonNode jsonNode = this.mapper.readTree(response.body().byteStream());
                return jsonNode;
            }
        }

        private Response acceptConsent(String consentChallenge, JsonNode consentRequest) throws IOException {
            return this.httpClient.newCall(new Request.Builder().url("https://localhost:" + TestingHydraIdentityProvider.this.getAdminPort() + "/oauth2/auth/requests/consent/accept?consent_challenge=" + consentChallenge).put(RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)this.mapper.writeValueAsString((Object)((ObjectNode)this.mapper.createObjectNode().set("grant_scope", consentRequest.get("requested_scope"))).set("grant_access_token_audience", consentRequest.get("requested_access_token_audience"))))).build()).execute();
        }

        private void sendRedirect(Response redirectResponse, HttpServletResponse response) throws IOException {
            Objects.requireNonNull(redirectResponse.body());
            response.sendRedirect(this.toHostUrl(this.mapper.readTree(redirectResponse.body().byteStream()).get("redirect_to").textValue()));
        }

        private String toHostUrl(String url) {
            return HttpUrl.get((String)url).newBuilder().port(TestingHydraIdentityProvider.this.getAuthPort()).toString();
        }
    }
}

