/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.jsonwebtoken.io.Encoders;
import io.trino.server.security.oauth2.RefreshTokensConfig;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.testng.annotations.Test;

public class TestRefreshTokensConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((RefreshTokensConfig)ConfigAssertions.recordDefaults(RefreshTokensConfig.class)).setTokenExpiration(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.HOURS)).setIssuer("Trino_coordinator").setAudience("Trino_coordinator").setSecretKey(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws Exception {
        String encodedBase64SecretKey = (String)Encoders.BASE64.encode((Object)this.generateKey());
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.refresh-tokens.issued-token.timeout", (Object)"24h").put((Object)"http-server.authentication.oauth2.refresh-tokens.issued-token.issuer", (Object)"issuer").put((Object)"http-server.authentication.oauth2.refresh-tokens.issued-token.audience", (Object)"audience").put((Object)"http-server.authentication.oauth2.refresh-tokens.secret-key", (Object)encodedBase64SecretKey).buildOrThrow();
        RefreshTokensConfig expected = new RefreshTokensConfig().setTokenExpiration(Duration.succinctDuration((double)24.0, (TimeUnit)TimeUnit.HOURS)).setIssuer("issuer").setAudience("audience").setSecretKey(encodedBase64SecretKey);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    private byte[] generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(256);
        SecretKey key = generator.generateKey();
        return key.getEncoded();
    }
}

