/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.node.NodeInfo;
import io.trino.server.security.Authenticator;
import io.trino.server.security.oauth2.OAuth2Authenticator;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2ServerConfigProvider;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.server.ui.OAuth2WebUiAuthenticationFilter;
import io.trino.server.ui.WebUiAuthenticationFilter;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOidcDiscovery {
    @Test(dataProvider="staticConfiguration")
    public void testStaticConfiguration(Optional<String> accessTokenPath, Optional<String> userinfoPath) throws Exception {
        try (MetadataServer metadataServer = new MetadataServer((Map<String, String>)ImmutableMap.of((Object)"/jwks.json", (Object)"jwk/jwk-public.json"));){
            URI issuer = metadataServer.getBaseUrl();
            Optional<URI> accessTokenIssuer = accessTokenPath.map(issuer::resolve);
            Optional<URI> userinfoUrl = userinfoPath.map(issuer::resolve);
            ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"false").put((Object)"http-server.authentication.oauth2.auth-url", (Object)issuer.resolve("/connect/authorize").toString()).put((Object)"http-server.authentication.oauth2.token-url", (Object)issuer.resolve("/connect/token").toString()).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)issuer.resolve("/jwks.json").toString());
            accessTokenIssuer.map(URI::toString).ifPresent(uri -> properties.put((Object)"http-server.authentication.oauth2.access-token-issuer", uri));
            userinfoUrl.map(URI::toString).ifPresent(uri -> properties.put((Object)"http-server.authentication.oauth2.userinfo-url", uri));
            try (TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)properties.buildOrThrow());){
                TestOidcDiscovery.assertConfiguration(server, issuer, accessTokenIssuer.map(issuer::resolve), userinfoUrl.map(issuer::resolve));
            }
        }
    }

    @DataProvider(name="staticConfiguration")
    public static Object[][] staticConfiguration() {
        return new Object[][]{{Optional.empty(), Optional.empty()}, {Optional.of("/access-token-issuer"), Optional.of("/userinfo")}};
    }

    @Test(dataProvider="oidcDiscovery")
    public void testOidcDiscovery(String configuration, Optional<String> accessTokenIssuer, Optional<String> userinfoUrl) throws Exception {
        try (MetadataServer metadataServer = new MetadataServer((Map<String, String>)ImmutableMap.builder().put((Object)"/.well-known/openid-configuration", (Object)("oidc/" + configuration)).put((Object)"/jwks.json", (Object)"jwk/jwk-public.json").buildOrThrow());
             TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").buildOrThrow());){
            URI issuer = metadataServer.getBaseUrl();
            TestOidcDiscovery.assertConfiguration(server, issuer, accessTokenIssuer.map(issuer::resolve), userinfoUrl.map(issuer::resolve));
        }
    }

    @DataProvider(name="oidcDiscovery")
    public static Object[][] oidcDiscovery() {
        return new Object[][]{{"openid-configuration.json", Optional.empty(), Optional.of("/connect/userinfo")}, {"openid-configuration-without-userinfo.json", Optional.empty(), Optional.empty()}, {"openid-configuration-with-access-token-issuer.json", Optional.of("http://access-token-issuer.com/adfs/services/trust"), Optional.of("/connect/userinfo")}};
    }

    @Test
    public void testIssuerCheck() {
        Assertions.assertThatThrownBy(() -> {
            try (MetadataServer metadataServer = new MetadataServer((Map<String, String>)ImmutableMap.builder().put((Object)"/.well-known/openid-configuration", (Object)"oidc/openid-configuration-invalid-issuer.json").put((Object)"/jwks.json", (Object)"jwk/jwk-public.json").buildOrThrow());
                 TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").buildOrThrow());){
                ((OAuth2ServerConfigProvider)server.getInstance(Key.get(OAuth2ServerConfigProvider.class))).get();
            }
        }).hasMessageContaining("Invalid response from OpenID Metadata endpoint. The value of the \"issuer\" claim in Metadata document different than the Issuer URL used for the Configuration Request.");
    }

    @Test
    public void testStopOnClientError() {
        Assertions.assertThatThrownBy(() -> {
            try (MetadataServer metadataServer = new MetadataServer((Map<String, String>)ImmutableMap.of());
                 TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").buildOrThrow());){
                ((OAuth2ServerConfigProvider)server.getInstance(Key.get(OAuth2ServerConfigProvider.class))).get();
            }
        }).hasMessageContaining("Invalid response from OpenID Metadata endpoint. Expected response code to be 200, but was 404");
    }

    @Test
    public void testOidcDiscoveryRetrying() throws Exception {
        try (MetadataServer metadataServer = new MetadataServer(new MetadataServletWithStartup((Map<String, String>)ImmutableMap.builder().put((Object)"/.well-known/openid-configuration", (Object)"oidc/openid-configuration.json").put((Object)"/jwks.json", (Object)"jwk/jwk-public.json").buildOrThrow(), 5));
             TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").put((Object)"http-server.authentication.oauth2.oidc.discovery.timeout", (Object)"10s").buildOrThrow());){
            URI issuer = metadataServer.getBaseUrl();
            TestOidcDiscovery.assertConfiguration(server, issuer, Optional.empty(), Optional.of(issuer.resolve("/connect/userinfo")));
        }
    }

    @Test
    public void testOidcDiscoveryTimesOut() {
        Assertions.assertThatThrownBy(() -> {
            try (MetadataServer metadataServer = new MetadataServer(new MetadataServletWithStartup((Map<String, String>)ImmutableMap.builder().put((Object)"/.well-known/openid-configuration", (Object)"oidc/openid-configuration.json").put((Object)"/jwks.json", (Object)"jwk/jwk-public.json").buildOrThrow(), 10));
                 TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").put((Object)"http-server.authentication.oauth2.oidc.discovery.timeout", (Object)"5s").buildOrThrow());){
                ((OAuth2ServerConfigProvider)server.getInstance(Key.get(OAuth2ServerConfigProvider.class))).get();
            }
        }).hasMessageContaining("Invalid response from OpenID Metadata endpoint: 429");
    }

    @Test
    public void testIgnoringUserinfoUrl() throws Exception {
        try (MetadataServer metadataServer = new MetadataServer((Map<String, String>)ImmutableMap.builder().put((Object)"/.well-known/openid-configuration", (Object)"oidc/openid-configuration.json").put((Object)"/jwks.json", (Object)"jwk/jwk-public.json").buildOrThrow());
             TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)metadataServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").put((Object)"http-server.authentication.oauth2.oidc.use-userinfo-endpoint", (Object)"false").buildOrThrow());){
            URI issuer = metadataServer.getBaseUrl();
            TestOidcDiscovery.assertConfiguration(server, issuer, Optional.empty(), Optional.empty());
        }
    }

    @Test
    public void testBackwardCompatibility() throws Exception {
        try (MetadataServer metadataServer = new MetadataServer((Map<String, String>)ImmutableMap.builder().put((Object)"/.well-known/openid-configuration", (Object)"oidc/openid-configuration-with-access-token-issuer.json").put((Object)"/jwks.json", (Object)"jwk/jwk-public.json").buildOrThrow());){
            URI issuer = metadataServer.getBaseUrl();
            URI authUrl = issuer.resolve("/custom-authorize");
            URI tokenUrl = issuer.resolve("/custom-token");
            URI jwksUrl = issuer.resolve("/custom-jwks.json");
            String accessTokenIssuer = issuer.resolve("/custom-access-token-issuer").toString();
            URI userinfoUrl = issuer.resolve("/custom-userinfo-url");
            try (TestingTrinoServer server = TestOidcDiscovery.createServer((Map<String, String>)ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)issuer.toString()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"true").put((Object)"http-server.authentication.oauth2.auth-url", (Object)authUrl.toString()).put((Object)"http-server.authentication.oauth2.token-url", (Object)tokenUrl.toString()).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwksUrl.toString()).put((Object)"http-server.authentication.oauth2.access-token-issuer", (Object)accessTokenIssuer).put((Object)"http-server.authentication.oauth2.userinfo-url", (Object)userinfoUrl.toString()).buildOrThrow());){
                TestOidcDiscovery.assertComponents(server);
                OAuth2ServerConfigProvider.OAuth2ServerConfig config = ((OAuth2ServerConfigProvider)server.getInstance(Key.get(OAuth2ServerConfigProvider.class))).get();
                Assertions.assertThat((Optional)config.getAccessTokenIssuer()).isEqualTo(Optional.of(accessTokenIssuer));
                Assertions.assertThat((URI)config.getAuthUrl()).isEqualTo((Object)authUrl);
                Assertions.assertThat((URI)config.getTokenUrl()).isEqualTo((Object)tokenUrl);
                Assertions.assertThat((URI)config.getJwksUrl()).isEqualTo((Object)jwksUrl);
                Assertions.assertThat((Optional)config.getUserinfoUrl()).isEqualTo(Optional.of(userinfoUrl));
            }
        }
    }

    private static void assertConfiguration(TestingTrinoServer server, URI issuer, Optional<URI> accessTokenIssuer, Optional<URI> userinfoUrl) {
        TestOidcDiscovery.assertComponents(server);
        OAuth2ServerConfigProvider.OAuth2ServerConfig config = ((OAuth2ServerConfigProvider)server.getInstance(Key.get(OAuth2ServerConfigProvider.class))).get();
        Assertions.assertThat((Optional)config.getAccessTokenIssuer()).isEqualTo(accessTokenIssuer.map(URI::toString));
        Assertions.assertThat((URI)config.getAuthUrl()).isEqualTo((Object)issuer.resolve("/connect/authorize"));
        Assertions.assertThat((URI)config.getTokenUrl()).isEqualTo((Object)issuer.resolve("/connect/token"));
        Assertions.assertThat((URI)config.getJwksUrl()).isEqualTo((Object)issuer.resolve("/jwks.json"));
        Assertions.assertThat((Optional)config.getUserinfoUrl()).isEqualTo(userinfoUrl);
    }

    private static void assertComponents(TestingTrinoServer server) {
        List authenticators = (List)server.getInstance(Key.get((TypeLiteral)new TypeLiteral<List<Authenticator>>(){}));
        Assertions.assertThat((List)authenticators).hasSize(1);
        Assertions.assertThat((Object)((Authenticator)authenticators.get(0))).isInstanceOf(OAuth2Authenticator.class);
        Assertions.assertThat((Object)((WebUiAuthenticationFilter)server.getInstance(Key.get(WebUiAuthenticationFilter.class)))).isInstanceOf(OAuth2WebUiAuthenticationFilter.class);
        ((OAuth2Client)server.getInstance(Key.get(OAuth2Client.class))).load();
    }

    private static TestingTrinoServer createServer(Map<String, String> configuration) {
        return TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"http-server.authentication.type", (Object)"oauth2").put((Object)"http-server.authentication.oauth2.client-id", (Object)"another-consumer").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"consumer-secret").putAll(configuration).buildOrThrow()).build();
    }

    public static class MetadataServer
    implements AutoCloseable {
        private final TestingHttpServer httpServer;

        public MetadataServer(Map<String, String> responseMapping) throws Exception {
            this(new MetadataServlet(responseMapping));
        }

        public MetadataServer(HttpServlet servlet) throws Exception {
            NodeInfo nodeInfo = new NodeInfo("test");
            HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
            HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
            this.httpServer = new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)servlet, (Map)ImmutableMap.of());
            this.httpServer.start();
        }

        public URI getBaseUrl() {
            return this.httpServer.getBaseUrl();
        }

        @Override
        public void close() throws Exception {
            this.httpServer.stop();
        }
    }

    public static class MetadataServletWithStartup
    extends MetadataServlet {
        private final Instant startTime;

        public MetadataServletWithStartup(Map<String, String> responseMapping, int startupInSeconds) {
            super(responseMapping);
            this.startTime = Instant.now().plusSeconds(startupInSeconds);
        }

        @Override
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (Instant.now().isBefore(this.startTime)) {
                response.setStatus(HttpStatus.TOO_MANY_REQUESTS.code());
                return;
            }
            super.doGet(request, response);
        }
    }

    public static class MetadataServlet
    extends HttpServlet {
        private final Map<String, String> responseMapping;

        public MetadataServlet(Map<String, String> responseMapping) {
            this.responseMapping = Objects.requireNonNull(responseMapping, "responseMapping is null");
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String fileName = this.responseMapping.get(request.getPathInfo());
            if (fileName == null) {
                response.setStatus(404);
                return;
            }
            response.setHeader("Content-Type", "application/json");
            String body = Resources.toString((URL)Resources.getResource((String)fileName), (Charset)StandardCharsets.UTF_8);
            body = body.replaceAll("https://issuer.com", request.getRequestURL().toString().replace("/.well-known/openid-configuration", ""));
            response.getWriter().write(body);
        }
    }
}

