/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.server.security.HeaderAuthenticatorConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHeaderAuthenticatorConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HeaderAuthenticatorConfig)ConfigAssertions.recordDefaults(HeaderAuthenticatorConfig.class)).setHeaderAuthenticatorFiles((List)ImmutableList.of((Object)"etc/header-authenticator.properties")).setUserMappingPattern(null).setUserMappingFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path config1 = Files.createTempFile(null, null, new FileAttribute[0]);
        Path config2 = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http-server.authentication.header.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.header.user-mapping.file", (Object)userMappingFile.toString()).put((Object)"header-authenticator.config-files", (Object)(config1.toString() + "," + config2.toString())).buildOrThrow();
        HeaderAuthenticatorConfig expected = new HeaderAuthenticatorConfig().setHeaderAuthenticatorFiles((List)ImmutableList.of((Object)config1.toAbsolutePath().toString(), (Object)config2.toAbsolutePath().toString())).setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

